/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.summary.Plan;
import org.neo4j.shell.prettyprint.OutputFormatter;

public class TablePlanFormatter {
    private static final String UNNAMED_PATTERN_STRING = "  (UNNAMED|FRESHID|AGGREGATION|NODE|REL)(\\d+)";
    private static final Pattern UNNAMED_PATTERN = Pattern.compile("  (UNNAMED|FRESHID|AGGREGATION|NODE|REL)(\\d+)");
    private static final String OPERATOR = "Operator";
    private static final String ESTIMATED_ROWS = "Estimated Rows";
    private static final String ROWS = "Rows";
    private static final String HITS = "DB Hits";
    private static final String PAGE_CACHE = "Cache H/M";
    private static final String TIME = "Time (ms)";
    private static final String ORDER = "Ordered by";
    private static final String MEMORY = "Memory (Bytes)";
    public static final String IDENTIFIERS = "Identifiers";
    private static final String OTHER = "Other";
    public static final String DETAILS = "Details";
    private static final String SEPARATOR = ", ";
    private static final Pattern DEDUP_PATTERN = Pattern.compile("\\s*(\\S+)@\\d+");
    public static final int MAX_DETAILS_COLUMN_WIDTH = 100;
    private static final List<String> HEADERS = Arrays.asList("Operator", "Details", "Estimated Rows", "Rows", "DB Hits", "Cache H/M", "Time (ms)", "Memory (Bytes)", "Identifiers", "Ordered by", "Other");
    private static final Set<String> IGNORED_ARGUMENTS = new LinkedHashSet<String>(Arrays.asList("Rows", "DbHits", "EstimatedRows", "planner", "planner-impl", "planner-version", "version", "runtime", "runtime-impl", "runtime-version", "time", "source-code", "PageCacheMisses", "PageCacheHits", "PageCacheHitRatio", "Order", "Memory", "GlobalMemory", "Details"));
    public static final Value ZERO_VALUE = Values.value((int)0);

    private int width(@Nonnull String header, @Nonnull Map<String, Integer> columns) {
        return 2 + Math.max(header.length(), columns.get(header));
    }

    private static void pad(int width, char chr, @Nonnull StringBuilder result) {
        result.append(OutputFormatter.repeat(chr, width));
    }

    private void divider(@Nonnull List<String> headers, @Nullable TableRow tableRow, @Nonnull StringBuilder result, @Nonnull Map<String, Integer> columns) {
        for (String header : headers) {
            if (tableRow != null && header.equals(OPERATOR) && tableRow.connection.isPresent()) {
                result.append("|");
                String connection = tableRow.connection.get();
                result.append(" ").append(connection);
                TablePlanFormatter.pad(this.width(header, columns) - connection.length() - 1, ' ', result);
                continue;
            }
            result.append("+");
            TablePlanFormatter.pad(this.width(header, columns), '-', result);
        }
        result.append("+").append(OutputFormatter.NEWLINE);
    }

    @Nonnull
    String formatPlan(@Nonnull Plan plan) {
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        List<TableRow> tableRows = this.accumulate(plan, new Root(), columns);
        List<String> headers = HEADERS.stream().filter(header -> columns.containsKey(header) && (!header.equals(IDENTIFIERS) || !columns.containsKey(DETAILS))).collect(Collectors.toList());
        StringBuilder result = new StringBuilder((2 + OutputFormatter.NEWLINE.length() + headers.stream().mapToInt(h -> this.width((String)h, (Map<String, Integer>)columns)).sum()) * (tableRows.size() * 2 + 3));
        ArrayList<TableRow> allTableRows = new ArrayList<TableRow>();
        Map<String, Cell> headerMap = headers.stream().map(header -> Pair.of(header, new LeftJustifiedCell((String)header))).collect(Collectors.toMap(p -> (String)p._1, p -> (Cell)p._2));
        allTableRows.add(new TableRow(OPERATOR, headerMap, Optional.empty()));
        allTableRows.addAll(tableRows);
        for (int rowIndex = 0; rowIndex < allTableRows.size(); ++rowIndex) {
            TableRow tableRow = (TableRow)allTableRows.get(rowIndex);
            this.divider(headers, tableRow, result, columns);
            for (int rowLineIndex = 0; rowLineIndex < tableRow.height; ++rowLineIndex) {
                for (String header2 : headers) {
                    Cell cell = tableRow.get(header2);
                    String defaultText = "";
                    if (header2.equals(OPERATOR) && rowIndex + 1 < allTableRows.size()) {
                        defaultText = ((TableRow)allTableRows.get((int)(rowIndex + 1))).connection.orElse("").replace('\\', ' ');
                    }
                    result.append("| ");
                    int columnWidth = this.width(header2, columns);
                    cell.writePaddedLine(rowLineIndex, defaultText, columnWidth, result);
                    result.append(" ");
                }
                result.append("|").append(OutputFormatter.NEWLINE);
            }
        }
        this.divider(headers, null, result, columns);
        return result.toString();
    }

    @Nonnull
    private String serialize(@Nonnull String key, @Nonnull Value v) {
        switch (key) {
            case "ColumnsLeft": {
                return this.removeGeneratedNames(v.asString());
            }
            case "LegacyExpression": {
                return this.removeGeneratedNames(v.asString());
            }
            case "Expression": {
                return this.removeGeneratedNames(v.asString());
            }
            case "UpdateActionName": {
                return v.asString();
            }
            case "LegacyIndex": {
                return v.toString();
            }
            case "version": {
                return v.toString();
            }
            case "planner": {
                return v.toString();
            }
            case "planner-impl": {
                return v.toString();
            }
            case "runtime": {
                return v.toString();
            }
            case "runtime-impl": {
                return v.toString();
            }
            case "MergePattern": {
                return "MergePattern(" + v.toString() + ")";
            }
            case "DbHits": {
                return v.asNumber().toString();
            }
            case "Rows": {
                return v.asNumber().toString();
            }
            case "Time": {
                return v.asNumber().toString();
            }
            case "EstimatedRows": {
                return v.asNumber().toString();
            }
            case "LabelName": {
                return v.asString();
            }
            case "KeyNames": {
                return this.removeGeneratedNames(v.asString());
            }
            case "KeyExpressions": {
                return String.join((CharSequence)SEPARATOR, v.asList(Value::asString));
            }
            case "ExpandExpression": {
                return this.removeGeneratedNames(v.asString());
            }
            case "Index": {
                return v.asString();
            }
            case "PrefixIndex": {
                return v.asString();
            }
            case "InequalityIndex": {
                return v.asString();
            }
            case "EntityByIdRhs": {
                return v.asString();
            }
            case "PageCacheMisses": {
                return v.asNumber().toString();
            }
            case "Details": {
                return v.asString();
            }
        }
        return v.asObject().toString();
    }

    @Nonnull
    private Stream<List<TableRow>> children(@Nonnull Plan plan, Level level, @Nonnull Map<String, Integer> columns) {
        List c = plan.children();
        switch (c.size()) {
            case 0: {
                return Stream.empty();
            }
            case 1: {
                return Stream.of(this.accumulate((Plan)c.get(0), level.child(), columns));
            }
            case 2: {
                return Stream.of(this.accumulate((Plan)c.get(1), level.fork(), columns), this.accumulate((Plan)c.get(0), level.child(), columns));
            }
        }
        throw new IllegalStateException("Plan has more than 2 children " + c);
    }

    @Nonnull
    private List<TableRow> accumulate(@Nonnull Plan plan, @Nonnull Level level, @Nonnull Map<String, Integer> columns) {
        String line = level.line() + plan.operatorType();
        this.mapping(OPERATOR, new LeftJustifiedCell(line), columns);
        return Stream.concat(Stream.of(new TableRow(line, this.details(plan, columns), level.connector())), this.children(plan, level, columns).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    @Nonnull
    private Map<String, Cell> details(@Nonnull Plan plan, @Nonnull Map<String, Integer> columns) {
        Map args = plan.arguments();
        Stream<Optional> formattedPlan = args.entrySet().stream().map(e -> {
            Value value = (Value)e.getValue();
            switch ((String)e.getKey()) {
                case "EstimatedRows": {
                    return this.mapping(ESTIMATED_ROWS, new RightJustifiedCell(this.format(value.asDouble())), columns);
                }
                case "Rows": {
                    return this.mapping(ROWS, new RightJustifiedCell(value.asNumber().toString()), columns);
                }
                case "DbHits": {
                    return this.mapping(HITS, new RightJustifiedCell(value.asNumber().toString()), columns);
                }
                case "PageCacheHits": {
                    return this.mapping(PAGE_CACHE, new RightJustifiedCell(String.format("%s/%s", value.asNumber(), args.getOrDefault("PageCacheMisses", ZERO_VALUE).asNumber())), columns);
                }
                case "Time": {
                    return this.mapping(TIME, new RightJustifiedCell(String.format("%.3f", (double)value.asLong() / 1000000.0)), columns);
                }
                case "Order": {
                    return this.mapping(ORDER, new LeftJustifiedCell(String.format("%s", value.asString())), columns);
                }
                case "Details": {
                    return this.mapping(DETAILS, new LeftJustifiedCell(this.splitDetails(value.asString())), columns);
                }
                case "Memory": {
                    return this.mapping(MEMORY, new RightJustifiedCell(String.format("%s", value.asNumber().toString())), columns);
                }
            }
            return Optional.empty();
        });
        return Stream.concat(formattedPlan, Stream.of(Optional.of(Pair.of(IDENTIFIERS, new LeftJustifiedCell(this.identifiers(plan, columns)))), Optional.of(Pair.of(OTHER, new LeftJustifiedCell(this.other(plan, columns)))))).filter(Optional::isPresent).collect(Collectors.toMap(o -> (String)((Pair)o.get())._1, o -> (Cell)((Pair)o.get())._2));
    }

    @Nonnull
    private Optional<Pair<String, Cell>> mapping(@Nonnull String key, @Nonnull Cell value, @Nonnull Map<String, Integer> columns) {
        this.update(columns, key, value.length);
        return Optional.of(Pair.of(key, value));
    }

    @Nonnull
    private String replaceAllIn(@Nonnull Pattern pattern, @Nonnull String s, @Nonnull Function<Matcher, String> mapper) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            matcher.appendReplacement(sb, mapper.apply(matcher));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Nonnull
    private String removeGeneratedNames(@Nonnull String s) {
        String named = this.replaceAllIn(UNNAMED_PATTERN, s, m -> "anon[" + m.group(2) + "]");
        return this.replaceAllIn(DEDUP_PATTERN, named, m -> m.group(1));
    }

    private void update(@Nonnull Map<String, Integer> columns, @Nonnull String key, int length) {
        columns.put(key, Math.max(columns.getOrDefault(key, 0), length));
    }

    @Nonnull
    private String identifiers(@Nonnull Plan description, @Nonnull Map<String, Integer> columns) {
        String result = description.identifiers().stream().map(this::removeGeneratedNames).collect(Collectors.joining(SEPARATOR));
        if (!result.isEmpty()) {
            this.update(columns, IDENTIFIERS, result.length());
        }
        return result;
    }

    @Nonnull
    private String other(@Nonnull Plan description, @Nonnull Map<String, Integer> columns) {
        String result = description.arguments().entrySet().stream().map(e -> {
            if (!IGNORED_ARGUMENTS.contains(e.getKey())) {
                return this.serialize((String)e.getKey(), (Value)e.getValue());
            }
            return "";
        }).filter(OutputFormatter::isNotBlank).collect(Collectors.joining("; ")).replaceAll(UNNAMED_PATTERN_STRING, "");
        if (!result.isEmpty()) {
            this.update(columns, OTHER, result.length());
        }
        return result;
    }

    @Nonnull
    private String format(@Nonnull Double v) {
        if (v.isNaN()) {
            return v.toString();
        }
        return String.valueOf(Math.round(v));
    }

    private String[] splitDetails(String original) {
        ArrayList<String> detailsList = new ArrayList<String>();
        int currentPos = 0;
        while (currentPos < original.length()) {
            int newPos = Math.min(original.length(), currentPos + 100);
            detailsList.add(original.substring(currentPos, newPos));
            currentPos = newPos;
        }
        return detailsList.toArray(new String[0]);
    }

    static final class Pair<T1, T2> {
        final T1 _1;
        final T2 _2;

        private Pair(T1 _1, T2 _2) {
            this._1 = _1;
            this._2 = _2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return this._1.equals(pair._1) && this._2.equals(pair._2);
        }

        public int hashCode() {
            return 31 * this._1.hashCode() + this._2.hashCode();
        }

        public static <T1, T2> Pair<T1, T2> of(T1 _1, T2 _2) {
            return new Pair<T1, T2>(_1, _2);
        }
    }

    static class Fork
    extends Level {
        private final int level;

        Fork(int level) {
            this.level = level;
        }

        @Override
        Level child() {
            return new Child(this.level);
        }

        @Override
        Level fork() {
            return new Fork(this.level + 1);
        }

        @Override
        String line() {
            return OutputFormatter.repeat("| ", this.level - 1) + "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.of(OutputFormatter.repeat("| ", this.level - 2) + "|\\");
        }
    }

    static class Child
    extends Level {
        private final int level;

        Child(int level) {
            this.level = level;
        }

        @Override
        Level child() {
            return new Child(this.level);
        }

        @Override
        Level fork() {
            return new Fork(this.level + 1);
        }

        @Override
        String line() {
            return OutputFormatter.repeat("| ", this.level - 1) + "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.of(OutputFormatter.repeat("| ", this.level));
        }
    }

    static class Root
    extends Level {
        Root() {
        }

        @Override
        Level child() {
            return new Child(1);
        }

        @Override
        Level fork() {
            return new Fork(2);
        }

        @Override
        String line() {
            return "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.empty();
        }
    }

    static abstract class Level {
        Level() {
        }

        abstract Level child();

        abstract Level fork();

        abstract String line();

        abstract Optional<String> connector();
    }

    static class RightJustifiedCell
    extends Cell {
        RightJustifiedCell(String ... lines) {
            super(lines);
        }

        @Override
        void writePaddedLine(int lineIndex, String orElseValue, int columnWidth, StringBuilder result) {
            String line = this.getLineOrElse(lineIndex, orElseValue);
            TablePlanFormatter.pad(this.paddingWidth(columnWidth, line), ' ', result);
            result.append(line);
        }
    }

    static class LeftJustifiedCell
    extends Cell {
        LeftJustifiedCell(String ... lines) {
            super(lines);
        }

        @Override
        void writePaddedLine(int lineIndex, String orElseValue, int columnWidth, StringBuilder result) {
            String line = this.getLineOrElse(lineIndex, orElseValue);
            result.append(line);
            TablePlanFormatter.pad(this.paddingWidth(columnWidth, line), ' ', result);
        }
    }

    static abstract class Cell {
        final int length;
        final String[] lines;

        Cell(String[] lines) {
            this.length = Stream.of(lines).mapToInt(String::length).max().orElse(0);
            this.lines = lines;
        }

        abstract void writePaddedLine(int var1, String var2, int var3, StringBuilder var4);

        protected int paddingWidth(int columnWidth, String line) {
            return columnWidth - line.length() - 2;
        }

        protected String getLineOrElse(int lineIndex, String orElseValue) {
            if (lineIndex < this.lines.length) {
                return this.lines[lineIndex];
            }
            return orElseValue;
        }
    }

    static class TableRow {
        private final String tree;
        private final Map<String, Cell> cells;
        private final Optional<String> connection;
        private final int height;

        TableRow(String tree, Map<String, Cell> cells, Optional<String> connection) {
            this.tree = tree;
            this.cells = cells;
            this.connection = connection == null ? Optional.empty() : connection;
            this.height = cells.values().stream().mapToInt(v -> v.lines.length).max().orElse(0);
        }

        Cell get(String key) {
            if (key.equals(TablePlanFormatter.OPERATOR)) {
                return new LeftJustifiedCell(this.tree);
            }
            return this.cells.getOrDefault(key, new LeftJustifiedCell(""));
        }
    }
}

