/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.Connector;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.TriFunction;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.NullLogging;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.state.ListBoltResult;
import org.neo4j.shell.state.StatementBoltResult;

public class BoltStateHandler
implements TransactionHandler,
Connector {
    private final TriFunction<String, AuthToken, Config, Driver> driverProvider;
    protected Driver driver;
    protected Session session;
    private String version;
    private List<Statement> transactionStatements;

    public BoltStateHandler() {
        this(GraphDatabase::driver);
    }

    BoltStateHandler(TriFunction<String, AuthToken, Config, Driver> driverProvider) {
        this.driverProvider = driverProvider;
    }

    @Override
    public void beginTransaction() throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (this.isTransactionOpen()) {
            throw new CommandException("There is already an open transaction");
        }
        this.transactionStatements = new ArrayList<Statement>();
    }

    @Override
    public Optional<List<BoltResult>> commitTransaction() throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (!this.isTransactionOpen()) {
            throw new CommandException("There is no open transaction to commit");
        }
        return this.captureResults(this.transactionStatements);
    }

    @Override
    public void rollbackTransaction() throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (!this.isTransactionOpen()) {
            throw new CommandException("There is no open transaction to rollback");
        }
        this.clearTransactionStatements();
    }

    @Override
    public boolean isTransactionOpen() {
        return this.transactionStatements != null;
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public void connect(@Nonnull ConnectionConfig connectionConfig) throws CommandException {
        if (this.isConnected()) {
            throw new CommandException("Already connected");
        }
        AuthToken authToken = AuthTokens.basic((String)connectionConfig.username(), (String)connectionConfig.password());
        try {
            this.driver = this.getDriver(connectionConfig, authToken);
            this.reconnect();
        }
        catch (Throwable t) {
            try {
                this.silentDisconnect();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private void reconnect() {
        String bookmark = null;
        if (this.session != null) {
            bookmark = this.session.lastBookmark();
            this.session.close();
        }
        this.session = this.driver.session(AccessMode.WRITE, bookmark);
        StatementResult run = this.session.run("RETURN 1");
        this.version = run.summary().server().version();
        run.consume();
    }

    @Override
    @Nonnull
    public String getServerVersion() {
        if (this.isConnected()) {
            if (this.version == null) {
                this.version = "";
            }
            if (this.version.startsWith("Neo4j/")) {
                this.version = this.version.substring(6);
            }
            return this.version;
        }
        return "";
    }

    @Nonnull
    public Optional<BoltResult> runCypher(@Nonnull String cypher, @Nonnull Map<String, Object> queryParams) throws CommandException {
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        if (this.transactionStatements != null) {
            this.transactionStatements.add(new Statement(cypher, queryParams));
            return Optional.empty();
        }
        try {
            return this.getBoltResult(cypher, queryParams);
        }
        catch (SessionExpiredException e) {
            this.reconnect();
            return this.getBoltResult(cypher, queryParams);
        }
    }

    @Nonnull
    private Optional<BoltResult> getBoltResult(@Nonnull String cypher, @Nonnull Map<String, Object> queryParams) throws SessionExpiredException {
        StatementResult statementResult = this.session.run(new Statement(cypher, queryParams));
        if (statementResult == null) {
            return Optional.empty();
        }
        return Optional.of(new StatementBoltResult(statementResult));
    }

    void silentDisconnect() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.driver != null) {
                this.driver.close();
            }
        }
        finally {
            this.session = null;
            this.driver = null;
        }
    }

    public void reset() {
        if (this.isConnected()) {
            this.session.reset();
            if (this.isTransactionOpen()) {
                this.clearTransactionStatements();
            }
        }
    }

    List<Statement> getTransactionStatements() {
        return this.transactionStatements;
    }

    private void clearTransactionStatements() {
        this.transactionStatements = null;
    }

    private Driver getDriver(@Nonnull ConnectionConfig connectionConfig, @Nullable AuthToken authToken) {
        Config config = Config.build().withLogging(NullLogging.NULL_LOGGING).withEncryptionLevel(connectionConfig.encryption()).toConfig();
        return this.driverProvider.apply(connectionConfig.driverUrl(), authToken, config);
    }

    private Optional<List<BoltResult>> captureResults(@Nonnull List<Statement> transactionStatements) {
        List<BoltResult> results = this.executeWithRetry(transactionStatements, (statement, transaction) -> {
            StatementResult sr = transaction.run(statement);
            return new ListBoltResult(sr.list(), sr.consume(), sr.keys());
        });
        this.clearTransactionStatements();
        if (results == null || results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(results);
    }

    private List<BoltResult> executeWithRetry(List<Statement> transactionStatements, BiFunction<Statement, Transaction, BoltResult> biFunction) {
        return (List)this.session.writeTransaction(tx -> transactionStatements.stream().map(transactionStatement -> (BoltResult)biFunction.apply((Statement)transactionStatement, tx)).collect(Collectors.toList()));
    }
}

