/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreConstArgumentAction;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.impl.choice.CollectionArgumentChoice;
import net.sourceforge.argparse4j.impl.type.BooleanArgumentType;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.neo4j.shell.cli.CliArgs;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.cli.Format;

public class CliArgHelper {
    static final Pattern ADDRESS_ARG_PATTERN = Pattern.compile("\\s*(?<scheme>[a-zA-Z0-9+\\-.]+://)?((?<username>\\w+):(?<password>[^\\s]+)@)?(?<host>[a-zA-Z\\d\\-.]+)?(:(?<port>\\d+))?\\s*");

    @Nullable
    public static CliArgs parse(String ... args) {
        String pass;
        Namespace ns;
        ArgumentParser parser = CliArgHelper.setupParser();
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return null;
        }
        Matcher addressMatcher = CliArgHelper.parseAddressMatcher(parser, ns.getString("address"));
        if (addressMatcher == null) {
            return null;
        }
        CliArgs cliArgs = new CliArgs();
        cliArgs.setScheme(addressMatcher.group("scheme"), "bolt://");
        cliArgs.setHost(addressMatcher.group("host"), "localhost");
        String portString = addressMatcher.group("port");
        cliArgs.setPort(portString == null ? 7687 : Integer.parseInt(portString));
        cliArgs.setUsername(addressMatcher.group("username"), "");
        cliArgs.setPassword(addressMatcher.group("password"), "");
        String user = ns.getString("username");
        if (!user.isEmpty()) {
            cliArgs.setUsername(user, cliArgs.getUsername());
        }
        if (!(pass = ns.getString("password")).isEmpty()) {
            cliArgs.setPassword(pass, cliArgs.getPassword());
        }
        cliArgs.setCypher(ns.getString("cypher"));
        cliArgs.setFailBehavior((FailBehavior)((Object)ns.get("fail-behavior")));
        cliArgs.setFormat(Format.parse((String)ns.get("format")));
        cliArgs.setEncryption(ns.getBoolean("encryption"));
        cliArgs.setDebugMode(ns.getBoolean("debug"));
        cliArgs.setNonInteractive(ns.getBoolean("force-non-interactive"));
        cliArgs.setWrap(ns.getBoolean("wrap"));
        cliArgs.setNumSampleRows(ns.getInt("sample-rows"));
        cliArgs.setVersion(ns.getBoolean("version"));
        cliArgs.setDriverVersion(ns.getBoolean("driver-version"));
        return cliArgs;
    }

    @Nullable
    private static Matcher parseAddressMatcher(ArgumentParser parser, String address) {
        Matcher matcher = ADDRESS_ARG_PATTERN.matcher(address);
        if (!matcher.matches()) {
            PrintWriter printWriter = new PrintWriter(System.err);
            parser.printUsage(printWriter);
            printWriter.println("cypher-shell: error: Failed to parse address: '" + address + "'");
            printWriter.println("\n  Address should be of the form: [scheme://][username:password@][host][:port]");
            printWriter.flush();
            return null;
        }
        return matcher;
    }

    private static ArgumentParser setupParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"cypher-shell").defaultHelp(true).description(String.format("A command line shell where you can execute Cypher against an instance of Neo4j. By default the shell is interactive but you can use it for scripting by passing cypher directly on the command line or by piping a file with cypher statements (requires Powershell on Windows).%n%nexample of piping a file:%n  cat some-cypher.txt | cypher-shell", new Object[0]));
        ArgumentGroup connGroup = parser.addArgumentGroup("connection arguments");
        connGroup.addArgument(new String[]{"-a", "--address"}).help("address and port to connect to").setDefault((Object)"bolt://localhost:7687");
        connGroup.addArgument(new String[]{"-u", "--username"}).setDefault((Object)"").help("username to connect as. Can also be specified using environment variable NEO4J_USERNAME");
        connGroup.addArgument(new String[]{"-p", "--password"}).setDefault((Object)"").help("password to connect with. Can also be specified using environment variable NEO4J_PASSWORD");
        connGroup.addArgument(new String[]{"--encryption"}).help("whether the connection to Neo4j should be encrypted; must be consistent with Neo4j's configuration").type((ArgumentType)new BooleanArgumentType()).setDefault((Object)true);
        MutuallyExclusiveGroup failGroup = parser.addMutuallyExclusiveGroup();
        failGroup.addArgument(new String[]{"--fail-fast"}).help("exit and report failure on first error when reading from file (this is the default behavior)").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_FAST).action((ArgumentAction)new StoreConstArgumentAction());
        failGroup.addArgument(new String[]{"--fail-at-end"}).help("exit and report failures at end of input when reading from file").dest("fail-behavior").setConst((Object)FailBehavior.FAIL_AT_END).action((ArgumentAction)new StoreConstArgumentAction());
        parser.setDefault("fail-behavior", (Object)FailBehavior.FAIL_FAST);
        parser.addArgument(new String[]{"--format"}).help("desired output format, verbose displays results in tabular format and prints statistics, plain displays data with minimal formatting").choices((ArgumentChoice)new CollectionArgumentChoice((Object[])new String[]{Format.AUTO.name().toLowerCase(), Format.VERBOSE.name().toLowerCase(), Format.PLAIN.name().toLowerCase()})).setDefault((Object)Format.AUTO.name().toLowerCase());
        parser.addArgument(new String[]{"--debug"}).help("print additional debug information").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--non-interactive"}).help("force non-interactive mode, only useful if auto-detection fails (like on Windows)").dest("force-non-interactive").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--sample-rows"}).help("number of rows sampled to compute table widths (only for format=VERBOSE)").type((ArgumentType)new PositiveIntegerType()).dest("sample-rows").setDefault((Object)1000);
        parser.addArgument(new String[]{"--wrap"}).help("wrap table colum values if column is too narrow (only for format=VERBOSE)").type((ArgumentType)new BooleanArgumentType()).setDefault((Object)true);
        parser.addArgument(new String[]{"-v", "--version"}).help("print version of cypher-shell and exit").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"--driver-version"}).help("print version of the Neo4j Driver used and exit").dest("driver-version").action((ArgumentAction)new StoreTrueArgumentAction());
        parser.addArgument(new String[]{"cypher"}).nargs("?").help("an optional string of cypher to execute and then exit");
        return parser;
    }

    private static class PositiveIntegerType
    implements ArgumentType<Integer> {
        private PositiveIntegerType() {
        }

        public Integer convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
            try {
                int result = Integer.parseInt(value);
                if (result < 1) {
                    throw new NumberFormatException(value);
                }
                return result;
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentParserException("Invalid value: " + value, parser);
            }
        }
    }
}

