/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.node;

import io.aeron.Aeron;
import io.aeron.driver.MediaDriver;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.nd4j.aeron.ipc.AeronUtil;
import org.nd4j.aeron.ipc.NDArrayCallback;
import org.nd4j.parameterserver.ParameterServerListener;
import org.nd4j.parameterserver.ParameterServerSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterServerNode
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ParameterServerNode.class);
    private ParameterServerSubscriber[] subscriber;
    private MediaDriver mediaDriver;
    private Aeron aeron;
    private int statusPort;
    private int numWorkers;

    public ParameterServerNode(MediaDriver mediaDriver, int statusPort) {
        this(mediaDriver, statusPort, Runtime.getRuntime().availableProcessors());
    }

    public ParameterServerNode(MediaDriver mediaDriver, int statusPort, int numWorkers) {
        this.mediaDriver = mediaDriver;
        this.statusPort = statusPort;
        this.numWorkers = numWorkers;
        this.subscriber = new ParameterServerSubscriber[numWorkers];
    }

    public ParameterServerNode(MediaDriver mediaDriver) {
        this(mediaDriver, 9000);
    }

    public void runMain(String[] args) {
        if (this.mediaDriver == null) {
            this.mediaDriver = MediaDriver.launchEmbedded();
        }
        log.info("Started media driver with aeron directory " + this.mediaDriver.aeronDirectoryName());
        NDArrayCallback parameterServerListener = null;
        ParameterServerListener cast = null;
        for (int i = 0; i < this.numWorkers; ++i) {
            int streamId;
            int streamIdIdx;
            this.subscriber[i] = new ParameterServerSubscriber(this.mediaDriver);
            if (this.aeron == null) {
                this.aeron = Aeron.connect((Aeron.Context)ParameterServerNode.getContext(this.mediaDriver));
            }
            this.subscriber[i].setAeron(this.aeron);
            ArrayList<String> multiArgs = new ArrayList<String>(Arrays.asList(args));
            if (multiArgs.contains("-id")) {
                streamIdIdx = multiArgs.indexOf("-id") + 1;
                streamId = Integer.parseInt((String)multiArgs.get(streamIdIdx)) + i;
                multiArgs.set(streamIdIdx, String.valueOf(streamId));
            } else if (multiArgs.contains("--streamId")) {
                streamIdIdx = multiArgs.indexOf("--streamId") + 1;
                streamId = Integer.parseInt((String)multiArgs.get(streamIdIdx)) + i;
                multiArgs.set(streamIdIdx, String.valueOf(streamId));
            }
            if (i == 0) {
                this.subscriber[i].run(multiArgs.toArray(new String[args.length]));
                parameterServerListener = this.subscriber[i].getCallback();
                cast = this.subscriber[i].getParameterServerListener();
                continue;
            }
            this.subscriber[i].setCallback(parameterServerListener);
            this.subscriber[i].setParameterServerListener(cast);
            this.subscriber[i].run(multiArgs.toArray(new String[args.length]));
        }
    }

    public boolean subscriberLaunched() {
        boolean launched = true;
        for (int i = 0; i < this.numWorkers; ++i) {
            launched = launched && this.subscriber[i].subscriberLaunched();
        }
        return launched;
    }

    @Override
    public void close() throws Exception {
        if (this.subscriber != null) {
            for (int i = 0; i < this.subscriber.length; ++i) {
                if (this.subscriber[i] == null) continue;
                this.subscriber[i].close();
            }
        }
        if (this.mediaDriver != null) {
            CloseHelper.quietClose((AutoCloseable)this.mediaDriver);
        }
        if (this.aeron != null) {
            CloseHelper.quietClose((AutoCloseable)this.aeron);
        }
    }

    private static Aeron.Context getContext(MediaDriver mediaDriver) {
        return new Aeron.Context().availableImageHandler(AeronUtil::printAvailableImage).unavailableImageHandler(AeronUtil::printUnavailableImage).aeronDirectoryName(mediaDriver.aeronDirectoryName()).keepAliveIntervalNs(100000L).errorHandler(e -> log.error(e.toString(), e));
    }

    public static void main(String[] args) {
        new ParameterServerNode().runMain(args);
    }

    public ParameterServerNode() {
    }

    public ParameterServerSubscriber[] getSubscriber() {
        return this.subscriber;
    }

    public MediaDriver getMediaDriver() {
        return this.mediaDriver;
    }

    public Aeron getAeron() {
        return this.aeron;
    }

    public int getStatusPort() {
        return this.statusPort;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public void setSubscriber(ParameterServerSubscriber[] subscriber) {
        this.subscriber = subscriber;
    }

    public void setMediaDriver(MediaDriver mediaDriver) {
        this.mediaDriver = mediaDriver;
    }

    public void setAeron(Aeron aeron) {
        this.aeron = aeron;
    }

    public void setStatusPort(int statusPort) {
        this.statusPort = statusPort;
    }

    public void setNumWorkers(int numWorkers) {
        this.numWorkers = numWorkers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterServerNode)) {
            return false;
        }
        ParameterServerNode other = (ParameterServerNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusPort() != other.getStatusPort()) {
            return false;
        }
        if (this.getNumWorkers() != other.getNumWorkers()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSubscriber(), other.getSubscriber())) {
            return false;
        }
        MediaDriver this$mediaDriver = this.getMediaDriver();
        MediaDriver other$mediaDriver = other.getMediaDriver();
        if (this$mediaDriver == null ? other$mediaDriver != null : !this$mediaDriver.equals(other$mediaDriver)) {
            return false;
        }
        Aeron this$aeron = this.getAeron();
        Aeron other$aeron = other.getAeron();
        return !(this$aeron == null ? other$aeron != null : !this$aeron.equals(other$aeron));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterServerNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusPort();
        result = result * 59 + this.getNumWorkers();
        result = result * 59 + Arrays.deepHashCode(this.getSubscriber());
        MediaDriver $mediaDriver = this.getMediaDriver();
        result = result * 59 + ($mediaDriver == null ? 43 : $mediaDriver.hashCode());
        Aeron $aeron = this.getAeron();
        result = result * 59 + ($aeron == null ? 43 : $aeron.hashCode());
        return result;
    }

    public String toString() {
        return "ParameterServerNode(subscriber=" + Arrays.deepToString(this.getSubscriber()) + ", mediaDriver=" + this.getMediaDriver() + ", aeron=" + this.getAeron() + ", statusPort=" + this.getStatusPort() + ", numWorkers=" + this.getNumWorkers() + ")";
    }
}

