/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.chunks.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.nd4j.common.primitives.AtomicBoolean;
import org.nd4j.common.util.ND4JFileUtils;
import org.nd4j.common.util.SerializationUtils;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.v2.chunks.ChunksTracker;
import org.nd4j.parameterserver.distributed.v2.chunks.VoidChunk;
import org.nd4j.parameterserver.distributed.v2.messages.VoidMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChunksTracker<T extends VoidMessage>
implements ChunksTracker<T> {
    private static final Logger log = LoggerFactory.getLogger(FileChunksTracker.class);
    private final String originId;
    private final int numChunks;
    private Map<Integer, AtomicBoolean> map = new ConcurrentHashMap<Integer, AtomicBoolean>();
    private File holder;
    private final long size;

    public FileChunksTracker(VoidChunk chunk) {
        this.originId = chunk.getOriginalId();
        this.numChunks = chunk.getNumberOfChunks();
        this.size = chunk.getTotalSize();
        try {
            this.holder = ND4JFileUtils.createTempFile((String)"FileChunksTracker", (String)"Message");
            this.holder.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(this.holder);
                 BufferedOutputStream bos = new BufferedOutputStream(fos, 32768);){
                int e = 0;
                while ((long)e < this.size) {
                    bos.write(0);
                    ++e;
                }
            }
            for (int e = 0; e < this.numChunks; ++e) {
                this.map.put(e, new AtomicBoolean(false));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean append(@NonNull VoidChunk chunk) {
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
        AtomicBoolean b = this.map.get(chunk.getChunkId());
        if (b.get()) {
            return this.isComplete();
        }
        try (RandomAccessFile f = new RandomAccessFile(this.holder, "rw");){
            f.seek(chunk.getChunkId() * chunk.getSplitSize());
            f.write(chunk.getPayload());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        b.set(true);
        return this.isComplete();
    }

    @Override
    public boolean isComplete() {
        for (AtomicBoolean b : this.map.values()) {
            if (b.get()) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public T getMessage() {
        if (!this.isComplete()) {
            throw new ND4JIllegalStateException("Message isn't ready for concatenation");
        }
        try (FileInputStream fis = new FileInputStream(this.holder);){
            VoidMessage voidMessage;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                voidMessage = (VoidMessage)SerializationUtils.deserialize((InputStream)bis);
            }
            return (T)voidMessage;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void release() {
        try {
            this.holder.delete();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOriginId() {
        return this.originId;
    }
}

