/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.rng;

import java.util.concurrent.atomic.AtomicInteger;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.ops.random.impl.UniformDistribution;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.rng.deallocator.NativePack;
import org.nd4j.rng.deallocator.NativeRandomDeallocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeRandom
implements Random {
    private static final Logger log = LoggerFactory.getLogger(NativeRandom.class);
    protected NativeOps nativeOps;
    protected DataBuffer stateBuffer;
    protected Pointer statePointer;
    protected long seed;
    protected long amplifier;
    protected long generation;
    protected long numberOfElements;
    protected AtomicInteger position = new AtomicInteger(0);
    protected LongPointer hostPointer;
    protected boolean isDestroyed = false;
    protected NativeRandomDeallocator deallocator;
    protected double z0;
    protected double z1;
    protected double u0;
    protected double u1;
    protected boolean generated = false;
    protected double mean = 0.0;
    protected double stdDev = 1.0;
    protected NativePack pack;

    public long getBufferSize() {
        return this.numberOfElements;
    }

    public int getPosition() {
        return this.position.get();
    }

    public long getGeneration() {
        return this.generation;
    }

    public NativeRandom() {
        this(System.currentTimeMillis());
    }

    public NativeRandom(long seed) {
        this(seed, 10000000L);
    }

    public NativeRandom(long seed, long numberOfElements) {
        this.amplifier = seed;
        this.generation = 1L;
        this.seed = seed;
        this.numberOfElements = numberOfElements;
        this.nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        this.stateBuffer = Nd4j.getDataBufferFactory().createDouble(numberOfElements);
        this.init();
        this.hostPointer = new LongPointer(this.stateBuffer.addressPointer());
        this.deallocator = NativeRandomDeallocator.getInstance();
        this.pack = new NativePack(this.statePointer.address(), this.statePointer);
        this.deallocator.trackStatePointer(this.pack);
    }

    public abstract void init();

    public void setSeed(int seed) {
        this.setSeed((long)seed);
    }

    public void setSeed(int[] seed) {
        long sd = 0L;
        for (int em : seed) {
            sd *= (long)em;
        }
        this.setSeed(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(long seed) {
        NativeRandom nativeRandom = this;
        synchronized (nativeRandom) {
            this.seed = seed;
            this.amplifier = seed;
            this.position.set(0);
            this.nativeOps.refreshBuffer(this.getExtraPointers(), seed, this.statePointer);
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public void nextBytes(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public int nextInt() {
        int next = (int)(this.amplifier == this.seed ? this.nextLong() : this.nextLong() * this.amplifier + 11L);
        return next < 0 ? -1 * next : next;
    }

    public int nextInt(int to) {
        int r = this.nextInt();
        int m = to - 1;
        if ((to & m) == 0) {
            r = (int)((long)to * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % to) + m < 0) {
                u = this.nextInt();
            }
        }
        return r;
    }

    public int nextInt(int a, int n) {
        return this.nextInt(n - a) + a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextLong() {
        long next = 0L;
        NativeRandom nativeRandom = this;
        synchronized (nativeRandom) {
            if ((long)this.position.get() >= this.numberOfElements) {
                this.position.set(0);
                ++this.generation;
            }
            next = this.hostPointer.get((long)this.position.getAndIncrement());
            if (this.generation > 1L) {
                next ^= this.generation + 11L;
            }
            if (this.amplifier != this.seed) {
                next ^= this.amplifier + 11L;
            }
        }
        return next < 0L ? -1L * next : next;
    }

    public abstract PointerPointer getExtraPointers();

    public boolean nextBoolean() {
        return this.nextInt() % 2 == 0;
    }

    public float nextFloat() {
        return (float)this.nextInt() / 2.1474836E9f;
    }

    public double nextDouble() {
        return (double)this.nextInt() / 2.147483647E9;
    }

    public double nextGaussian() {
        double epsilon = 1.0E-15;
        double two_pi = Math.PI * 2;
        if (!this.generated) {
            do {
                this.u0 = this.nextDouble();
                this.u1 = this.nextDouble();
            } while (this.u0 <= epsilon);
            this.z0 = Math.sqrt(-2.0 * Math.log(this.u0)) * Math.cos(two_pi * this.u1);
            this.z1 = Math.sqrt(-2.0 * Math.log(this.u0)) * Math.sin(two_pi * this.u1);
            this.generated = true;
            return this.z0 * this.stdDev + this.mean;
        }
        this.generated = false;
        return this.z1 * this.stdDev + this.mean;
    }

    public INDArray nextGaussian(int[] shape) {
        return this.nextGaussian(Nd4j.order().charValue(), shape);
    }

    public INDArray nextGaussian(long[] shape) {
        return this.nextGaussian(Nd4j.order().charValue(), shape);
    }

    public INDArray nextGaussian(char order, int[] shape) {
        INDArray array = Nd4j.createUninitialized((int[])shape, (char)order);
        GaussianDistribution op = new GaussianDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec((RandomOp)op, (Random)this);
        return array;
    }

    public INDArray nextGaussian(char order, long[] shape) {
        INDArray array = Nd4j.createUninitialized((long[])shape, (char)order);
        GaussianDistribution op = new GaussianDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec((RandomOp)op, (Random)this);
        return array;
    }

    public INDArray nextDouble(int[] shape) {
        return this.nextDouble(Nd4j.order().charValue(), shape);
    }

    public INDArray nextDouble(long[] shape) {
        return this.nextDouble(Nd4j.order().charValue(), shape);
    }

    public INDArray nextDouble(char order, int[] shape) {
        INDArray array = Nd4j.createUninitialized((int[])shape, (char)order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec((RandomOp)op, (Random)this);
        return array;
    }

    public INDArray nextDouble(char order, long[] shape) {
        INDArray array = Nd4j.createUninitialized((long[])shape, (char)order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec((RandomOp)op, (Random)this);
        return array;
    }

    public INDArray nextFloat(int[] shape) {
        return this.nextFloat(Nd4j.order().charValue(), shape);
    }

    public INDArray nextFloat(long[] shape) {
        return this.nextFloat(Nd4j.order().charValue(), shape);
    }

    public INDArray nextFloat(char order, int[] shape) {
        INDArray array = Nd4j.createUninitialized((int[])shape, (char)order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec((RandomOp)op, (Random)this);
        return array;
    }

    public INDArray nextFloat(char order, long[] shape) {
        INDArray array = Nd4j.createUninitialized((long[])shape, (char)order);
        UniformDistribution op = new UniformDistribution(array, 0.0, 1.0);
        Nd4j.getExecutioner().exec((RandomOp)op, (Random)this);
        return array;
    }

    public INDArray nextInt(int[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray nextInt(long[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray nextInt(int n, int[] shape) {
        throw new UnsupportedOperationException();
    }

    public INDArray nextInt(int n, long[] shape) {
        throw new UnsupportedOperationException();
    }

    public Pointer getStatePointer() {
        return this.statePointer;
    }

    public DataBuffer getStateBuffer() {
        return this.stateBuffer;
    }

    public void reSeed() {
        this.reSeed(System.currentTimeMillis());
    }

    public void reSeed(long amplifier) {
        this.amplifier = amplifier;
        this.nativeOps.reSeedBuffer(this.getExtraPointers(), amplifier, this.getStatePointer());
    }

    public void close() throws Exception {
    }
}

