/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.util.Properties;
import org.nd4j.context.Nd4jContext;
import org.nd4j.nativeblas.NativeOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOpsHolder {
    private static Logger log = LoggerFactory.getLogger(NativeOpsHolder.class);
    private static final NativeOpsHolder INSTANCE = new NativeOpsHolder();
    private final NativeOps deviceNativeOps;

    private NativeOpsHolder() {
        try {
            Properties props = Nd4jContext.getInstance().getConf();
            Class<NativeOps> nativeOpsClazz = Class.forName(System.getProperty("native.ops", props.get("native.ops").toString())).asSubclass(NativeOps.class);
            this.deviceNativeOps = nativeOpsClazz.newInstance();
            this.deviceNativeOps.initializeDevicesAndFunctions();
            String numThreadsString = System.getenv("OMP_NUM_THREADS");
            if (numThreadsString != null && !numThreadsString.isEmpty()) {
                int numThreads = Integer.parseInt(numThreadsString);
                this.deviceNativeOps.setOmpNumThreads(numThreads);
            } else {
                this.deviceNativeOps.setOmpNumThreads(NativeOps.getCores(Runtime.getRuntime().availableProcessors()));
            }
            log.info("Number of threads used for NativeOps: {}", (Object)this.deviceNativeOps.ompGetMaxThreads());
        }
        catch (Error | Exception e) {
            throw new RuntimeException("ND4J is probably missing dependencies. For more information, please refer to: http://nd4j.org/getstarted.html", e);
        }
    }

    public static NativeOpsHolder getInstance() {
        return INSTANCE;
    }

    public NativeOps getDeviceNativeOps() {
        return this.deviceNativeOps;
    }
}

