/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

public enum DataType {
    DOUBLE,
    FLOAT,
    HALF,
    LONG,
    INT,
    SHORT,
    UBYTE,
    BYTE,
    BOOL,
    UTF8,
    COMPRESSED,
    UNKNOWN;


    public static DataType fromInt(int type) {
        switch (type) {
            case 1: {
                return BOOL;
            }
            case 3: {
                return HALF;
            }
            case 5: {
                return FLOAT;
            }
            case 6: {
                return DOUBLE;
            }
            case 7: {
                return BYTE;
            }
            case 8: {
                return SHORT;
            }
            case 9: {
                return INT;
            }
            case 10: {
                return LONG;
            }
            case 11: {
                return UBYTE;
            }
        }
        throw new UnsupportedOperationException("Unknown data type: [" + type + "]");
    }

    public boolean isFPType() {
        return this == FLOAT || this == DOUBLE || this == HALF;
    }

    public boolean isIntType() {
        return this == LONG || this == INT || this == SHORT || this == UBYTE || this == BYTE;
    }

    public static DataType fromNumpy(String numpyDtypeName) {
        switch (numpyDtypeName.toLowerCase()) {
            case "bool": {
                return BOOL;
            }
            case "byte": {
                return BYTE;
            }
            case "int8": {
                return BYTE;
            }
            case "int16": {
                return SHORT;
            }
            case "int32": {
                return INT;
            }
            case "int64": {
                return LONG;
            }
            case "uint8": {
                return UBYTE;
            }
            case "float16": {
                return HALF;
            }
            case "float32": {
                return FLOAT;
            }
            case "float64": {
                return DOUBLE;
            }
        }
        throw new IllegalStateException("Unknown datatype or no ND4J equivalent datatype exists: " + numpyDtypeName);
    }
}

