/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.unsafe;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public class UnsafeHolder {
    private static Unsafe INSTANCE;
    private static Field ADDRESS_FIELD;
    private static boolean is64Bit;

    private UnsafeHolder() {
    }

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static Field getAddressField() throws NoSuchFieldException {
        if (ADDRESS_FIELD == null) {
            ADDRESS_FIELD = UnsafeHolder.getDeclaredFieldRecursive(ByteBuffer.class, "address");
        }
        return ADDRESS_FIELD;
    }

    private static Field getDeclaredFieldRecursive(Class<?> root, String fieldName) throws NoSuchFieldException {
        Class<?> type = root;
        while (true) {
            try {
                return type.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if ((type = type.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(fieldName + " does not exist in " + root.getSimpleName() + " or any of its superclasses.");
            }
            break;
        }
    }

    public static Unsafe getUnsafe() throws Exception {
        if (INSTANCE == null) {
            Field[] fields;
            for (Field field : fields = Unsafe.class.getDeclaredFields()) {
                int modifiers;
                if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                try {
                    INSTANCE = (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {}
                break;
            }
        }
        return INSTANCE;
    }

    static {
        is64Bit = System.getProperty("sun.arch.data.model").equals("64");
    }
}

