/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.UByteRawIndexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.util.AllocUtil;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataBuffer
implements DataBuffer {
    protected DataBuffer.Type type;
    protected DataBuffer.Type globalType = DataTypeUtil.getDtypeFromContext();
    protected long length;
    protected long underlyingLength;
    protected long offset;
    protected int elementSize;
    protected transient ByteBuffer wrappedBuffer;
    protected transient DataBuffer wrappedDataBuffer;
    protected Collection<String> referencing = Collections.synchronizedSet(new HashSet());
    protected boolean isPersist = false;
    protected DataBuffer.AllocationMode allocationMode;
    protected transient Pointer pointer;
    protected transient Indexer indexer;
    protected AtomicBoolean dirty = new AtomicBoolean(false);
    protected transient DataBuffer originalBuffer;
    protected transient long originalOffset = 0L;
    protected transient Long trackingPoint;
    protected transient boolean constant = false;
    private static Logger log = LoggerFactory.getLogger(BaseDataBuffer.class);

    public BaseDataBuffer() {
    }

    protected abstract void initTypeAndSize();

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    public BaseDataBuffer(Pointer pointer, Indexer indexer, long length) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.allocationMode = DataBuffer.AllocationMode.JAVACPP;
        this.underlyingLength = length;
        this.wrappedDataBuffer = this;
        this.pointer = pointer;
        this.indexer = indexer;
    }

    protected BaseDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.offset = offset;
        this.allocationMode = underlyingBuffer.allocationMode();
        this.elementSize = underlyingBuffer.getElementSize();
        this.underlyingLength = underlyingBuffer.underlyingLength();
        this.wrappedDataBuffer = underlyingBuffer;
        if (underlyingBuffer.originalDataBuffer() == null) {
            this.originalBuffer = underlyingBuffer;
            this.originalOffset = offset;
        } else {
            this.originalBuffer = underlyingBuffer.originalDataBuffer();
            this.originalOffset = offset;
        }
        this.pointer = underlyingBuffer.pointer();
        this.indexer = underlyingBuffer.indexer();
    }

    @Override
    public DataBuffer originalDataBuffer() {
        return this.originalBuffer;
    }

    public BaseDataBuffer(float[] data, boolean copy, int offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(float[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new FloatPointer(data);
        this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
        this.wrappedBuffer = this.pointer.asByteBuffer();
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(double[] data, boolean copy, int offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.underlyingLength = data.length;
        this.length = this.underlyingLength - (long)offset;
    }

    public BaseDataBuffer(double[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new DoublePointer(data);
        this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        this.wrappedBuffer = this.pointer.asByteBuffer();
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(int[] data, boolean copy, int offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(int[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new IntPointer(data);
        this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
        this.wrappedBuffer = this.pointer.asByteBuffer();
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(double[] data) {
        this(data, true);
    }

    public BaseDataBuffer(int[] data) {
        this(data, true);
    }

    public BaseDataBuffer(float[] data) {
        this(data, true);
    }

    public BaseDataBuffer(int length, int elementSize, int offset) {
        this((long)length, elementSize);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = length - offset;
        this.underlyingLength = length;
    }

    public BaseDataBuffer(long length, int elementSize) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = length;
        this.underlyingLength = length;
        this.elementSize = elementSize;
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(length);
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(length);
            this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(length);
            this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
        }
    }

    public BaseDataBuffer(ByteBuffer buffer, long length, int offset) {
        this(buffer, length);
        this.offset = offset;
        this.originalOffset = offset;
        this.underlyingLength = length;
        this.length = length - (long)offset;
    }

    public BaseDataBuffer(ByteBuffer buffer, long length) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(buffer.asDoubleBuffer());
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(buffer.asFloatBuffer());
            this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(buffer.asIntBuffer());
            this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
        }
    }

    protected void setNioBuffer() {
        if ((long)this.elementSize * this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create buffer of length " + this.length);
        }
        this.wrappedBuffer = this.pointer.asByteBuffer();
    }

    public BaseDataBuffer(byte[] data, long length) {
        this(ByteBuffer.wrap(data), length);
    }

    @Override
    public Indexer indexer() {
        return this.indexer;
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public DataBuffer underlyingDataBuffer() {
        return this.wrappedDataBuffer;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public DataBuffer.AllocationMode allocationMode() {
        return this.allocationMode;
    }

    @Override
    public void persist() {
        this.isPersist = true;
    }

    @Override
    public boolean isPersist() {
        return this.isPersist;
    }

    @Override
    public void unPersist() {
        this.isPersist = false;
    }

    private void fillPointerWithZero() {
        Pointer.memset((Pointer)this.pointer(), (int)0, (long)((long)this.getElementSize() * this.length()));
    }

    protected BaseDataBuffer(long length) {
        this(length, true);
    }

    protected BaseDataBuffer(long length, boolean initialize) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.underlyingLength = length;
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        if (length < 0L) {
            throw new IllegalArgumentException("Unable to create a buffer of length <= 0");
        }
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(this.length());
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(this.length());
            this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(this.length());
            this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
            if (initialize) {
                this.fillPointerWithZero();
            }
        }
    }

    @Override
    public void copyAtStride(DataBuffer buf, long n, long stride, long yStride, long offset, long yOffset) {
        if (this.dataType() == DataBuffer.Type.FLOAT) {
            int i = 0;
            while ((long)i < n) {
                this.put(offset + (long)i * stride, buf.getFloat(yOffset + (long)i * yStride));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < n) {
                this.put(offset + (long)i * stride, buf.getDouble(yOffset + (long)i * yStride));
                ++i;
            }
        }
    }

    @Override
    public void removeReferencing(String id) {
        this.referencing.remove(id);
    }

    @Override
    public Collection<String> references() {
        return this.referencing;
    }

    @Override
    public Pointer addressPointer() {
        if (this.offset() > 0L) {
            if (this.dataType() == DataBuffer.Type.DOUBLE) {
                return new DoublePointer(this.pointer){
                    {
                        this.address = BaseDataBuffer.this.pointer.address() + (long)BaseDataBuffer.this.getElementSize() * BaseDataBuffer.this.offset();
                    }
                };
            }
            if (this.dataType() == DataBuffer.Type.FLOAT) {
                return new FloatPointer(this.pointer){
                    {
                        this.address = BaseDataBuffer.this.pointer.address() + (long)BaseDataBuffer.this.getElementSize() * BaseDataBuffer.this.offset();
                    }
                };
            }
            if (this.dataType() == DataBuffer.Type.INT) {
                return new IntPointer(this.pointer){
                    {
                        this.address = BaseDataBuffer.this.pointer.address() + (long)BaseDataBuffer.this.getElementSize() * BaseDataBuffer.this.offset();
                    }
                };
            }
        }
        return this.pointer;
    }

    @Override
    public long address() {
        return this.pointer.address() + (long)this.getElementSize() * this.offset();
    }

    @Override
    public void addReferencing(String id) {
        this.referencing.add(id);
    }

    @Override
    public void assign(long[] indices, float[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void setData(int[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(float[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        int i = 0;
        while (i < indices.length) {
            this.put(indices[i], data[i]);
            i = (int)((long)i + inc);
        }
    }

    @Override
    public void assign(DataBuffer data) {
        if (data.length() != this.length()) {
            throw new IllegalArgumentException("Unable to assign buffer of length " + data.length() + " to this buffer of length " + this.length());
        }
        int i = 0;
        while ((long)i < data.length()) {
            this.put((long)i, data.getDouble(i));
            ++i;
        }
    }

    @Override
    public void assign(long[] indices, float[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1L);
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1L);
    }

    @Override
    public long underlyingLength() {
        return this.underlyingLength;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void assign(Number value) {
        int i = 0;
        while ((long)i < this.length()) {
            this.assign(value, i);
            ++i;
        }
    }

    @Override
    public double[] getDoublesAt(long offset, int length) {
        return this.getDoublesAt(offset, 1L, length);
    }

    @Override
    public float[] getFloatsAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getFloat((long)i + offset);
        }
        return ret;
    }

    @Override
    public DataBuffer dup() {
        DataBuffer ret = this.create(this.length);
        int i = 0;
        while ((long)i < ret.length()) {
            ret.put((long)i, this.getDouble(i));
            ++i;
        }
        return ret;
    }

    protected abstract DataBuffer create(long var1);

    public abstract DataBuffer create(double[] var1);

    public abstract DataBuffer create(float[] var1);

    public abstract DataBuffer create(int[] var1);

    @Override
    public double[] getDoublesAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getDouble((long)i + offset);
        }
        return ret;
    }

    @Override
    public float[] getFloatsAt(long offset, int length) {
        return this.getFloatsAt(offset, 1L, length);
    }

    @Override
    public abstract IComplexFloat getComplexFloat(long var1);

    @Override
    public abstract IComplexDouble getComplexDouble(long var1);

    @Override
    public IComplexNumber getComplex(long i) {
        return this.dataType() == DataBuffer.Type.FLOAT ? this.getComplexFloat(i) : this.getComplexDouble(i);
    }

    @Override
    public void put(long i, IComplexNumber result) {
        this.put(i, result.realComponent().doubleValue());
        this.put(i + 1L, result.imaginaryComponent().doubleValue());
    }

    @Override
    public void assign(long[] offsets, long[] strides, DataBuffer ... buffers) {
        this.assign(offsets, strides, this.length(), buffers);
    }

    @Override
    public byte[] asBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            int i = 0;
            while ((long)i < this.length()) {
                try {
                    dos.writeDouble(this.getDouble(i));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length()) {
                try {
                    dos.writeFloat(this.getFloat(i));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return bos.toByteArray();
    }

    @Override
    public float[] asFloat() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        float[] ret = new float[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getFloat(i);
            ++i;
        }
        return ret;
    }

    @Override
    public double[] asDouble() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        double[] ret = new double[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getDouble(i);
            ++i;
        }
        return ret;
    }

    @Override
    public int[] asInt() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        int[] ret = new int[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getInt(i);
            ++i;
        }
        return ret;
    }

    @Override
    public double getDouble(long i) {
        if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.dirty.set(false);
            if (this.indexer instanceof FloatIndexer) {
                return ((FloatIndexer)this.indexer).get(this.offset() + i);
            }
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            return other.get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            this.dirty.set(false);
            if (this.indexer instanceof IntIndexer) {
                return ((IntIndexer)this.indexer).get(this.offset() + i);
            }
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            return other.get(this.offset() + i);
        }
        this.dirty.set(false);
        if (this.indexer instanceof DoubleIndexer) {
            return ((DoubleIndexer)this.indexer).get(this.offset() + i);
        }
        UByteRawIndexer other = (UByteRawIndexer)this.indexer;
        return other.get(this.offset() + i);
    }

    protected short getShort(long i) {
        if (this.dataType() != DataBuffer.Type.HALF) {
            throw new UnsupportedOperationException("getShort() is supported for Half-precision buffers only");
        }
        return BaseDataBuffer.fromFloat(((HalfIndexer)this.indexer).get(this.offset() + i));
    }

    public static short fromFloat(float v) {
        if (Float.isNaN(v)) {
            return Short.MAX_VALUE;
        }
        if (v == Float.POSITIVE_INFINITY) {
            return 31744;
        }
        if (v == Float.NEGATIVE_INFINITY) {
            return -1024;
        }
        if (v == 0.0f) {
            return 0;
        }
        if (v == -0.0f) {
            return Short.MIN_VALUE;
        }
        if (v > 65504.0f) {
            return 31743;
        }
        if (v < -65504.0f) {
            return -1025;
        }
        if (v > 0.0f && v < 5.96046E-8f) {
            return 1;
        }
        if (v < 0.0f && v > -5.96046E-8f) {
            return -32767;
        }
        int f = Float.floatToIntBits(v);
        return (short)(f >> 16 & 0x8000 | (f & 0x7F800000) - 0x38000000 >> 13 & 0x7C00 | f >> 13 & 0x3FF);
    }

    @Override
    public float getFloat(long i) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.dirty.set(false);
            if (this.indexer instanceof DoubleIndexer) {
                return (float)((DoubleIndexer)this.indexer).get(this.offset() + i);
            }
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            return other.get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            this.dirty.set(false);
            if (this.indexer instanceof IntIndexer) {
                return ((IntIndexer)this.indexer).get(this.offset() + i);
            }
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            return other.get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.HALF) {
            this.dirty.set(false);
            if (this.indexer instanceof HalfIndexer) {
                return ((HalfIndexer)this.indexer).get(this.offset() + i);
            }
            throw new RuntimeException("Unsupported indexer was used for Half-precision buffer");
        }
        this.dirty.set(false);
        if (this.indexer instanceof FloatIndexer) {
            return ((FloatIndexer)this.indexer).get(this.offset() + i);
        }
        UByteRawIndexer other = (UByteRawIndexer)this.indexer;
        return other.get(this.offset() + i);
    }

    @Override
    public int getInt(long i) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.dirty.set(false);
            if (this.indexer instanceof DoubleIndexer) {
                return (int)((DoubleIndexer)this.indexer).get(this.offset() + i);
            }
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            return other.get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            this.dirty.set(false);
            if (this.indexer instanceof IntIndexer) {
                return ((IntIndexer)this.indexer).get(this.offset() + i);
            }
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            return other.get(this.offset() + i);
        }
        if (this.indexer instanceof FloatIndexer) {
            return (int)((FloatIndexer)this.indexer).get(this.offset() + i);
        }
        UByteRawIndexer other = (UByteRawIndexer)this.indexer;
        return other.get(this.offset() + i);
    }

    @Override
    public Number getNumber(long i) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            return this.getDouble(i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            return this.getInt(i);
        }
        return Float.valueOf(this.getFloat(i));
    }

    public void pointerIndexerByGlobalType(DataBuffer.Type currentType) {
        if (currentType == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(this.length());
            this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
            this.type = DataBuffer.Type.INT;
        } else if (this.globalType == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(this.length());
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (this.globalType == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(this.length());
            this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
        }
    }

    public void putByGlobalType(long i, Number element) {
        if (this.globalType == DataBuffer.Type.INT || this.type == DataBuffer.Type.INT) {
            int anElement = element.intValue();
            this.put(i, anElement);
        } else if (this.globalType == DataBuffer.Type.FLOAT || this.globalType == DataBuffer.Type.HALF) {
            float anElement = element.floatValue();
            this.put(i, anElement);
        } else if (this.globalType == DataBuffer.Type.DOUBLE) {
            double anElement = element.doubleValue();
            this.put(i, anElement);
        }
    }

    @Override
    public void put(long i, float element) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            if (this.indexer instanceof DoubleIndexer) {
                ((DoubleIndexer)this.indexer).put(this.offset() + i, (double)element);
            } else {
                UByteRawIndexer other = (UByteRawIndexer)this.indexer;
                other.put(this.offset() + i, (int)element);
            }
        } else if (this.dataType() == DataBuffer.Type.INT) {
            if (this.indexer instanceof IntIndexer) {
                ((IntIndexer)this.indexer).put(this.offset() + i, (int)element);
            } else {
                UByteRawIndexer other = (UByteRawIndexer)this.indexer;
                other.put(this.offset() + i, (int)element);
            }
        } else if (this.indexer instanceof FloatIndexer) {
            ((FloatIndexer)this.indexer).put(this.offset() + i, element);
        } else {
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            other.put(this.offset() + i, (int)element);
        }
        this.dirty.set(true);
    }

    @Override
    public void put(long i, double element) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            if (this.indexer instanceof DoubleIndexer) {
                ((DoubleIndexer)this.indexer).put(this.offset() + i, element);
            } else {
                UByteRawIndexer other = (UByteRawIndexer)this.indexer;
                other.put(this.offset() + i, (int)element);
            }
        } else if (this.dataType() == DataBuffer.Type.INT) {
            if (this.indexer instanceof IntIndexer) {
                ((IntIndexer)this.indexer).put(this.offset() + i, (int)element);
            } else {
                UByteRawIndexer other = (UByteRawIndexer)this.indexer;
                other.put(this.offset() + i, (int)element);
            }
        } else if (this.dataType() == DataBuffer.Type.HALF) {
            if (this.indexer instanceof HalfIndexer) {
                ((HalfIndexer)this.indexer).put(this.offset() + i, (float)element);
            }
        } else if (this.indexer instanceof FloatIndexer) {
            ((FloatIndexer)this.indexer).put(this.offset() + i, (float)element);
        } else {
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            other.put(this.offset() + i, (int)element);
        }
        this.dirty.set(true);
    }

    @Override
    public void put(long i, int element) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            if (this.indexer instanceof DoubleIndexer) {
                ((DoubleIndexer)this.indexer).put(this.offset() + i, (double)element);
            } else {
                UByteRawIndexer other = (UByteRawIndexer)this.indexer;
                other.put(this.offset() + i, element);
            }
        } else if (this.dataType() == DataBuffer.Type.INT) {
            if (this.indexer instanceof IntIndexer) {
                ((IntIndexer)this.indexer).put(this.offset() + i, element);
            } else {
                UByteRawIndexer other = (UByteRawIndexer)this.indexer;
                other.put(this.offset() + i, element);
            }
        } else if (this.indexer instanceof FloatIndexer) {
            ((FloatIndexer)this.indexer).put(this.offset() + i, (float)element);
        } else {
            UByteRawIndexer other = (UByteRawIndexer)this.indexer;
            other.put(this.offset() + i, element);
        }
        this.dirty.set(true);
    }

    @Override
    public boolean dirty() {
        return this.dirty.get();
    }

    @Override
    public boolean sameUnderlyingData(DataBuffer buffer) {
        return this.pointer() == buffer.pointer();
    }

    @Override
    public IntBuffer asNioInt() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.wrappedBuffer == null) {
            return this.pointer.asByteBuffer().asIntBuffer();
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer.asIntBuffer();
        }
        return (IntBuffer)this.wrappedBuffer.asIntBuffer().position((int)this.offset());
    }

    @Override
    public DoubleBuffer asNioDouble() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.wrappedBuffer == null) {
            return this.pointer.asByteBuffer().asDoubleBuffer();
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer.asDoubleBuffer();
        }
        return (DoubleBuffer)this.wrappedBuffer.asDoubleBuffer().position((int)this.offset());
    }

    @Override
    public FloatBuffer asNioFloat() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.wrappedBuffer == null) {
            return this.pointer.asByteBuffer().asFloatBuffer();
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer.asFloatBuffer();
        }
        return (FloatBuffer)this.wrappedBuffer.asFloatBuffer().position((int)this.offset());
    }

    @Override
    public ByteBuffer asNio() {
        if (this.wrappedBuffer == null) {
            return this.pointer.asByteBuffer();
        }
        return this.wrappedBuffer;
    }

    @Override
    public void assign(Number value, long offset) {
        for (long i = offset; i < this.length(); ++i) {
            this.put(i, value.doubleValue());
        }
    }

    @Override
    public void write(OutputStream dos) {
        if (dos instanceof DataOutputStream) {
            try {
                this.write((DataOutputStream)dos);
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Exception writing buffer", e);
            }
        }
        DataOutputStream dos2 = new DataOutputStream(dos);
        try {
            this.write(dos2);
        }
        catch (IOException e) {
            throw new IllegalStateException("IO Exception writing buffer", e);
        }
    }

    @Override
    public void read(InputStream is) {
        if (is instanceof DataInputStream) {
            this.read((DataInputStream)is);
        } else {
            DataInputStream dis2 = new DataInputStream(is);
            this.read(dis2);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void assign(long[] offsets, long[] strides, long n, DataBuffer ... buffers) {
        if (offsets.length != strides.length || strides.length != buffers.length) {
            throw new IllegalArgumentException("Unable to assign buffers, please specify equal lengths strides, offsets, and buffers");
        }
        int count = 0;
        for (int i = 0; i < buffers.length; ++i) {
            for (long j = offsets[i]; j < buffers[i].length(); j += strides[i]) {
                this.put((long)count++, buffers[i].getDouble(j));
            }
        }
        if ((long)count != n) {
            throw new IllegalArgumentException("Strides and offsets didn't match up to length " + n);
        }
    }

    @Override
    public void assign(DataBuffer ... buffers) {
        long[] offsets = new long[buffers.length];
        long[] strides = new long[buffers.length];
        for (int i = 0; i < strides.length; ++i) {
            strides[i] = 1L;
        }
        this.assign(offsets, strides, buffers);
    }

    @Override
    public void destroy() {
    }

    @Override
    public DataBuffer.Type dataType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o instanceof DataBuffer) {
            DataBuffer d = (DataBuffer)o;
            if (d.length() != this.length()) {
                return false;
            }
            int i = 0;
            while ((long)i < this.length()) {
                double eps = Math.abs(this.getDouble(i) - d.getDouble(i));
                if (eps > 1.0E-12) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream s) {
        this.doReadObject(s);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void doReadObject(ObjectInputStream s) {
        try {
            s.defaultReadObject();
            this.read(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void read(DataInputStream s) {
        try {
            this.referencing = Collections.synchronizedSet(new HashSet());
            this.dirty = new AtomicBoolean(false);
            this.allocationMode = DataBuffer.AllocationMode.valueOf(s.readUTF());
            this.length = s.readInt();
            DataBuffer.Type currentType = DataBuffer.Type.valueOf(s.readUTF());
            this.type = currentType != DataBuffer.Type.COMPRESSED ? this.globalType : currentType;
            if (this.globalType == DataBuffer.Type.DOUBLE && currentType != DataBuffer.Type.INT) {
                this.elementSize = 8;
            } else if (this.globalType == DataBuffer.Type.FLOAT || currentType == DataBuffer.Type.INT) {
                this.elementSize = 4;
            } else if (this.globalType == DataBuffer.Type.HALF && currentType != DataBuffer.Type.INT) {
                this.elementSize = 2;
            }
            if (currentType != this.globalType && currentType != DataBuffer.Type.HALF && currentType != DataBuffer.Type.INT && this.globalType != DataBuffer.Type.DOUBLE) {
                log.warn("Loading a data stream with type different from what is set globally. Expect precision loss");
                if (this.globalType == DataBuffer.Type.INT) {
                    log.warn("Int to float/double widening UNSUPPORTED!!!");
                }
            }
            this.pointerIndexerByGlobalType(currentType);
            if (currentType != DataBuffer.Type.COMPRESSED) {
                this.readContent(s, currentType);
            }
            this.wrappedBuffer = this.pointer.asByteBuffer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void readContent(DataInputStream s, DataBuffer.Type currentType) {
        try {
            if (currentType == DataBuffer.Type.DOUBLE) {
                int i = 0;
                while ((long)i < this.length()) {
                    this.putByGlobalType(i, s.readDouble());
                    ++i;
                }
            } else if (currentType == DataBuffer.Type.FLOAT) {
                int i = 0;
                while ((long)i < this.length()) {
                    this.putByGlobalType(i, Float.valueOf(s.readFloat()));
                    ++i;
                }
            } else if (currentType == DataBuffer.Type.COMPRESSED) {
                String compressionAlgorithm = s.readUTF();
                long compressedLength = s.readLong();
                long originalLength = s.readLong();
                long numberOfElements = s.readLong();
                byte[] temp = new byte[(int)compressedLength];
                int i = 0;
                while ((long)i < compressedLength) {
                    temp[i] = s.readByte();
                    ++i;
                }
                this.pointer = new BytePointer(temp);
                this.type = DataBuffer.Type.COMPRESSED;
            } else if (currentType == DataBuffer.Type.HALF) {
                int i = 0;
                while ((long)i < this.length()) {
                    this.putByGlobalType(i, Float.valueOf(this.toFloat(s.readShort())));
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < this.length()) {
                    this.putByGlobalType(i, s.readInt());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        if (this.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of data buffer can not be >= Integer.MAX_VALUE on output");
        }
        out.writeUTF(this.allocationMode.name());
        out.writeInt((int)this.length());
        out.writeUTF(this.dataType().name());
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            int i = 0;
            while ((long)i < this.length()) {
                out.writeDouble(this.getDouble(i));
                ++i;
            }
        } else if (this.dataType() == DataBuffer.Type.INT) {
            int i = 0;
            while ((long)i < this.length()) {
                out.writeInt(this.getInt(i));
                ++i;
            }
        } else if (this.dataType() == DataBuffer.Type.HALF) {
            int i = 0;
            while ((long)i < this.length()) {
                out.writeShort(this.getShort(i));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length()) {
                out.writeFloat(this.getFloat(i));
                ++i;
            }
        }
    }

    public float toFloat(int hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            exp += 114688;
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    @Override
    public Object array() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        int i = 0;
        while ((long)i < this.length()) {
            ret.append(this.getNumber(i));
            if ((long)i < this.length() - 1L) {
                ret.append(",");
            }
            ++i;
        }
        ret.append("]");
        return ret.toString();
    }

    public int hashCode() {
        int result = (int)this.length;
        result = 31 * result + (this.referencing != null ? this.referencing.hashCode() : 0);
        result = 31 * result + (this.isPersist ? 1 : 0);
        result = 31 * result + (this.allocationMode != null ? this.allocationMode.hashCode() : 0);
        return result;
    }

    @Override
    public long originalOffset() {
        return this.originalOffset;
    }

    @Override
    public Long getTrackingPoint() {
        return this.trackingPoint;
    }

    @Override
    public void setTrackingPoint(Long trackingPoint) {
        this.trackingPoint = trackingPoint;
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public void setConstant(boolean reallyConstant) {
        this.constant = reallyConstant;
    }
}

