/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.profiler.data.primitives;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.profiler.data.primitives.ComparableAtomicLong;

public class TimeSet
implements Comparable<TimeSet> {
    private List<ComparableAtomicLong> times = new ArrayList<ComparableAtomicLong>();
    private long sum = 0L;

    public void addTime(long time) {
        this.times.add(new ComparableAtomicLong(time));
        this.sum = 0L;
    }

    public long getSum() {
        if (this.sum == 0L) {
            for (ComparableAtomicLong time : this.times) {
                this.sum += time.get();
            }
        }
        return this.sum;
    }

    public long getAverage() {
        if (this.times.size() == 0) {
            return 0L;
        }
        long tSum = this.getSum();
        return tSum / (long)this.times.size();
    }

    public long getMedian() {
        if (this.times.size() == 0) {
            return 0L;
        }
        return this.times.get(this.times.size() / 2).longValue();
    }

    public long getMinimum() {
        long min = Long.MAX_VALUE;
        for (ComparableAtomicLong time : this.times) {
            if (time.get() >= min) continue;
            min = time.get();
        }
        return min;
    }

    public long getMaximum() {
        long max = Long.MIN_VALUE;
        for (ComparableAtomicLong time : this.times) {
            if (time.get() <= max) continue;
            max = time.get();
        }
        return max;
    }

    public int size() {
        return this.times.size();
    }

    @Override
    public int compareTo(TimeSet o) {
        return Long.compare(o.getSum(), this.getSum());
    }
}

