/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.NesterovsUpdater;
import org.nd4j.linalg.learning.config.IUpdater;

public class Nesterovs
implements IUpdater {
    public static final double DEFAULT_NESTEROV_MOMENTUM = 0.9;
    public static final double DEFAULT_NESTEROV_LEARNING_RATE = 0.1;
    private double learningRate;
    private double momentum;
    private Map<Integer, Double> momentumSchedule;

    public Nesterovs() {
        this(0.1, 0.9, null);
    }

    public Nesterovs(double momentum) {
        this(0.1, momentum);
    }

    public Nesterovs(double learningRate, double momentum) {
        this(learningRate, momentum, null);
    }

    @Override
    public long stateSize(long numParams) {
        return numParams;
    }

    @Override
    public void applySchedules(int iteration, double newLearningRate) {
        this.learningRate = newLearningRate;
        if (this.momentumSchedule != null && this.momentumSchedule.containsKey(iteration)) {
            this.momentum = this.momentumSchedule.get(iteration);
        }
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        NesterovsUpdater u = new NesterovsUpdater(this);
        u.setStateViewArray(viewArray, viewArray.shape(), viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public Nesterovs clone() {
        return new Nesterovs(this.learningRate, this.momentum, (Map<Integer, Double>)(this.momentumSchedule == null ? null : new HashMap<Integer, Double>(this.momentumSchedule)));
    }

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"learningRate", "momentum", "momentumSchedule"})
    public Nesterovs(double learningRate, double momentum, Map<Integer, Double> momentumSchedule) {
        this.learningRate = learningRate;
        this.momentum = momentum;
        this.momentumSchedule = momentumSchedule;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public Map<Integer, Double> getMomentumSchedule() {
        return this.momentumSchedule;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setMomentumSchedule(Map<Integer, Double> momentumSchedule) {
        this.momentumSchedule = momentumSchedule;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nesterovs)) {
            return false;
        }
        Nesterovs other = (Nesterovs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
            return false;
        }
        Map<Integer, Double> this$momentumSchedule = this.getMomentumSchedule();
        Map<Integer, Double> other$momentumSchedule = other.getMomentumSchedule();
        return !(this$momentumSchedule == null ? other$momentumSchedule != null : !((Object)this$momentumSchedule).equals(other$momentumSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nesterovs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        Map<Integer, Double> $momentumSchedule = this.getMomentumSchedule();
        result = result * 59 + ($momentumSchedule == null ? 43 : ((Object)$momentumSchedule).hashCode());
        return result;
    }

    public String toString() {
        return "Nesterovs(learningRate=" + this.getLearningRate() + ", momentum=" + this.getMomentum() + ", momentumSchedule=" + this.getMomentumSchedule() + ")";
    }

    public static class Builder {
        private Map<Integer, Double> momentumSchedule;
        private double learningRate = 0.1;
        private double momentum = 0.1;

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder momentum(double momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder momentumSchedule(Map<Integer, Double> momentumSchedule) {
            this.momentumSchedule = momentumSchedule;
            return this;
        }

        public Nesterovs build() {
            return new Nesterovs(this.learningRate, this.momentum, this.momentumSchedule);
        }

        public String toString() {
            return "Nesterovs.Builder(learningRate=" + this.learningRate + ", momentum=" + this.momentum + ", momentumSchedule=" + this.momentumSchedule + ")";
        }
    }
}

