/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api;

import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtil {
    private static final Logger log = LoggerFactory.getLogger(DataSetUtil.class);

    public static INDArray tailor2d(@NonNull DataSet dataSet, boolean areFeatures) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet");
        }
        return DataSetUtil.tailor2d(areFeatures ? dataSet.getFeatures() : dataSet.getLabels(), areFeatures ? dataSet.getFeaturesMaskArray() : dataSet.getLabelsMaskArray());
    }

    public static INDArray tailor2d(@NonNull INDArray data, INDArray mask) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        switch (data.rank()) {
            case 1: 
            case 2: {
                return data;
            }
            case 3: {
                return DataSetUtil.tailor3d2d(data, mask);
            }
            case 4: {
                return DataSetUtil.tailor4d2d(data);
            }
        }
        throw new RuntimeException("Unsupported data rank");
    }

    public static INDArray tailor3d2d(DataSet dataset, boolean areFeatures) {
        INDArray data = areFeatures ? dataset.getFeatures() : dataset.getLabels();
        INDArray mask = areFeatures ? dataset.getFeaturesMaskArray() : dataset.getLabelsMaskArray();
        return DataSetUtil.tailor3d2d(data, mask);
    }

    public static INDArray tailor3d2d(@NonNull INDArray data, INDArray mask) {
        INDArray as2d;
        int[] shape;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (mask != null && (data.size(0) != mask.size(0) || data.size(2) != mask.size(1))) {
            throw new IllegalArgumentException("Invalid mask array/data combination: got data with shape [minibatch, vectorSize, timeSeriesLength] = " + Arrays.toString(data.shape()) + "; got mask with shape [minibatch,timeSeriesLength] = " + Arrays.toString(mask.shape()) + "; minibatch and timeSeriesLength dimensions must match");
        }
        if (data.ordering() != 'f' || data.isView() || !Shape.strideDescendingCAscendingF(data)) {
            data = data.dup('f');
        }
        if ((shape = data.shape())[0] == 1) {
            as2d = data.tensorAlongDimension(0, 1, 2).permutei(1, 0);
        } else if (shape[2] == 1) {
            as2d = data.tensorAlongDimension(0, 1, 0);
        } else {
            INDArray permuted = data.permute(0, 2, 1);
            as2d = permuted.reshape('f', shape[0] * shape[2], shape[1]);
        }
        if (mask == null) {
            return as2d;
        }
        if (mask.ordering() != 'f' || mask.isView() || !Shape.strideDescendingCAscendingF(mask)) {
            mask = mask.dup('f');
        }
        INDArray mask1d = mask.reshape('f', new int[]{mask.length(), 1});
        int numElements = mask.sumNumber().intValue();
        if (numElements == mask.length()) {
            return as2d;
        }
        if (numElements == 0) {
            return null;
        }
        int[] rowsToPull = new int[numElements];
        float[] floatMask1d = mask1d.data().asFloat();
        int currCount = 0;
        for (int i = 0; i < floatMask1d.length; ++i) {
            if (floatMask1d[i] == 0.0f) continue;
            rowsToPull[currCount++] = i;
        }
        INDArray subset = Nd4j.pullRows(as2d, 1, rowsToPull);
        return subset;
    }

    public static INDArray tailor4d2d(DataSet dataset, boolean areFeatures) {
        return DataSetUtil.tailor4d2d(areFeatures ? dataset.getFeatures() : dataset.getLabels());
    }

    public static INDArray tailor4d2d(@NonNull INDArray data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        int instances = data.size(0);
        int channels = data.size(1);
        int height = data.size(2);
        int width = data.size(3);
        INDArray in2d = Nd4j.create(channels, height * width * instances);
        int tads = data.tensorssAlongDimension(3, 2, 0);
        for (int i = 0; i < tads; ++i) {
            INDArray thisTAD = data.tensorAlongDimension(i, 3, 2, 0);
            in2d.putRow(i, Nd4j.toFlattened(thisTAD));
        }
        return in2d.transposei();
    }

    public static void setMaskedValuesToZero(INDArray data, INDArray mask) {
        if (mask == null || data.rank() != 3) {
            return;
        }
        Nd4j.getExecutioner().exec(new BroadcastMulOp(data, mask, data, 0, 2));
    }

    public static Pair<INDArray, INDArray> mergeFeatures(@NonNull INDArray[] featuresToMerge, INDArray[] featureMasksToMerge) {
        if (featuresToMerge == null) {
            throw new NullPointerException("featuresToMerge");
        }
        int rankFeatures = featuresToMerge[0].rank();
        switch (rankFeatures) {
            case 2: {
                return DataSetUtil.merge2d(featuresToMerge, featureMasksToMerge);
            }
            case 3: {
                return DataSetUtil.mergeTimeSeries(featuresToMerge, featureMasksToMerge);
            }
            case 4: {
                return DataSetUtil.merge4d(featuresToMerge, featureMasksToMerge);
            }
        }
        throw new IllegalStateException("Cannot merge examples: features rank must be in range 2 to 4 inclusive. First example features shape: " + Arrays.toString(featureMasksToMerge[0].shape()));
    }

    public static Pair<INDArray, INDArray> mergeFeatures(INDArray[][] featuresToMerge, INDArray[][] featureMasksToMerge, int inOutIdx) {
        Pair<INDArray[], INDArray[]> p = DataSetUtil.selectColumnFromMDSData(featuresToMerge, featureMasksToMerge, inOutIdx);
        return DataSetUtil.mergeFeatures((INDArray[])p.getFirst(), (INDArray[])p.getSecond());
    }

    public static Pair<INDArray, INDArray> mergeLabels(INDArray[] labelsToMerge, INDArray[] labelMasksToMerge) {
        int rankFeatures = labelsToMerge[0].rank();
        switch (rankFeatures) {
            case 2: {
                return DataSetUtil.merge2d(labelsToMerge, labelMasksToMerge);
            }
            case 3: {
                return DataSetUtil.mergeTimeSeries(labelsToMerge, labelMasksToMerge);
            }
            case 4: {
                return DataSetUtil.merge4d(labelsToMerge, labelMasksToMerge);
            }
        }
        throw new IllegalStateException("Cannot merge examples: labels rank must be in range 2 to 4 inclusive. First example features shape: " + Arrays.toString(labelMasksToMerge[0].shape()));
    }

    public static Pair<INDArray, INDArray> mergeLabels(@NonNull INDArray[][] labelsToMerge, INDArray[][] labelMasksToMerge, int inOutIdx) {
        if (labelsToMerge == null) {
            throw new NullPointerException("labelsToMerge");
        }
        Pair<INDArray[], INDArray[]> p = DataSetUtil.selectColumnFromMDSData(labelsToMerge, labelMasksToMerge, inOutIdx);
        return DataSetUtil.mergeLabels((INDArray[])p.getFirst(), (INDArray[])p.getSecond());
    }

    private static Pair<INDArray[], INDArray[]> selectColumnFromMDSData(@NonNull INDArray[][] arrays, INDArray[][] masks, int inOutIdx) {
        if (arrays == null) {
            throw new NullPointerException("arrays");
        }
        INDArray[] a = new INDArray[arrays.length];
        INDArray[] m = new INDArray[a.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = arrays[i][inOutIdx];
            if (masks == null || masks[i] == null) continue;
            m[i] = masks[i][inOutIdx];
        }
        return new Pair((Object)a, (Object)m);
    }

    public static Pair<INDArray, INDArray> merge2d(@NonNull INDArray[][] arrays, INDArray[][] masks, int inOutIdx) {
        if (arrays == null) {
            throw new NullPointerException("arrays");
        }
        Pair<INDArray[], INDArray[]> p = DataSetUtil.selectColumnFromMDSData(arrays, masks, inOutIdx);
        return DataSetUtil.merge2d((INDArray[])p.getFirst(), (INDArray[])p.getSecond());
    }

    public static Pair<INDArray, INDArray> merge2d(INDArray[] arrays, INDArray[] masks) {
        int cols = arrays[0].columns();
        INDArray[] temp = new INDArray[arrays.length];
        boolean hasMasks = false;
        for (int i = 0; i < arrays.length; ++i) {
            if (arrays[i].columns() != cols) {
                throw new IllegalStateException("Cannot merge 2d arrays with different numbers of columns (firstNCols=" + cols + ", ithNCols=" + arrays[i].columns() + ")");
            }
            temp[i] = arrays[i];
            if (masks == null || masks[i] == null || masks[i] == null) continue;
            hasMasks = true;
        }
        INDArray out = Nd4j.specialConcat(0, temp);
        INDArray outMask = null;
        if (hasMasks) {
            outMask = DataSetUtil.mergePerOutputMasks2d(out.shape(), arrays, masks);
        }
        return new Pair((Object)out, outMask);
    }

    public static INDArray mergePerOutputMasks2d(int[] outShape, INDArray[][] arrays, INDArray[][] masks, int inOutIdx) {
        Pair<INDArray[], INDArray[]> p = DataSetUtil.selectColumnFromMDSData(arrays, masks, inOutIdx);
        return DataSetUtil.mergePerOutputMasks2d(outShape, (INDArray[])p.getFirst(), (INDArray[])p.getSecond());
    }

    public static INDArray mergePerOutputMasks2d(int[] outShape, INDArray[] arrays, INDArray[] masks) {
        int[] numExamplesPerArr = new int[arrays.length];
        for (int i = 0; i < numExamplesPerArr.length; ++i) {
            numExamplesPerArr[i] = arrays[i].size(0);
        }
        INDArray outMask = Nd4j.ones(outShape);
        int rowsSoFar = 0;
        for (int i = 0; i < masks.length; ++i) {
            int thisRows = numExamplesPerArr[i];
            if (masks[i] == null) continue;
            outMask.put(new INDArrayIndex[]{NDArrayIndex.interval(rowsSoFar, rowsSoFar + thisRows), NDArrayIndex.all()}, masks[i]);
            rowsSoFar += thisRows;
        }
        return outMask;
    }

    public static Pair<INDArray, INDArray> mergeTimeSeries(INDArray[][] arrays, INDArray[][] masks, int inOutIdx) {
        Pair<INDArray[], INDArray[]> p = DataSetUtil.selectColumnFromMDSData(arrays, masks, inOutIdx);
        return DataSetUtil.mergeTimeSeries((INDArray[])p.getFirst(), (INDArray[])p.getSecond());
    }

    public static Pair<INDArray, INDArray> mergeTimeSeries(INDArray[] arrays, INDArray[] masks) {
        int firstLength = arrays[0].size(2);
        int size = arrays[0].size(1);
        int maxLength = firstLength;
        boolean hasMask = false;
        int maskRank = -1;
        boolean lengthsDiffer = false;
        int totalExamples = 0;
        for (int i = 0; i < arrays.length; ++i) {
            totalExamples += arrays[i].size(0);
            int thisLength = arrays[i].size(2);
            maxLength = Math.max(maxLength, thisLength);
            if (thisLength != firstLength) {
                lengthsDiffer = true;
            }
            if (masks != null && masks[i] != null && masks[i] != null) {
                maskRank = masks[i].rank();
                hasMask = true;
            }
            if (arrays[i].size(1) == size) continue;
            throw new IllegalStateException("Cannot merge time series with different size for dimension 1 (first shape: " + Arrays.toString(arrays[0].shape()) + ", " + i + "th shape: " + Arrays.toString(arrays[i].shape()));
        }
        boolean needMask = hasMask || lengthsDiffer;
        INDArray arr = Nd4j.create(totalExamples, size, maxLength);
        INDArray mask = needMask && maskRank != 3 ? Nd4j.ones(totalExamples, maxLength) : null;
        int examplesSoFar = 0;
        if (!lengthsDiffer && !needMask) {
            for (int i = 0; i < arrays.length; ++i) {
                int thisNExamples = arrays[i].size(0);
                arr.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.all(), NDArrayIndex.all()}, arrays[i]);
                examplesSoFar += thisNExamples;
            }
            return new Pair((Object)arr, null);
        }
        if (lengthsDiffer && !hasMask || maskRank == 2) {
            for (int i = 0; i < arrays.length; ++i) {
                INDArray a = arrays[i];
                int thisNExamples = a.size(0);
                int thisLength = a.size(2);
                arr.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.all(), NDArrayIndex.interval(0, thisLength)}, a);
                if (masks != null && masks[i] != null && masks[i] != null) {
                    INDArray origMask = masks[i];
                    int maskLength = origMask.size(1);
                    mask.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.interval(0, maskLength)}, origMask);
                    if (maskLength < maxLength) {
                        mask.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.interval(maskLength, maxLength)}, Nd4j.zeros(thisNExamples, maxLength - maskLength));
                    }
                } else if (thisLength < maxLength) {
                    mask.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.interval(thisLength, maxLength)}, Nd4j.zeros(thisNExamples, maxLength - thisLength));
                }
                examplesSoFar += thisNExamples;
            }
        } else if (maskRank == 3) {
            mask = Nd4j.create(arr.shape());
            for (int i = 0; i < arrays.length; ++i) {
                INDArray m = masks[i];
                INDArray a = arrays[i];
                int thisNExamples = a.size(0);
                int thisLength = a.size(2);
                arr.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.all(), NDArrayIndex.interval(0, thisLength)}, a);
                if (m == null) {
                    mask.get(NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.all(), NDArrayIndex.interval(0, thisLength)).assign(1);
                } else {
                    mask.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.all(), NDArrayIndex.interval(0, thisLength)}, m);
                }
                examplesSoFar += thisNExamples;
            }
        } else {
            throw new UnsupportedOperationException("Cannot merge time series with mask rank " + maskRank);
        }
        return new Pair((Object)arr, (Object)mask);
    }

    public static Pair<INDArray, INDArray> merge4d(INDArray[][] arrays, INDArray[][] masks, int inOutIdx) {
        Pair<INDArray[], INDArray[]> p = DataSetUtil.selectColumnFromMDSData(arrays, masks, inOutIdx);
        return DataSetUtil.merge4d((INDArray[])p.getFirst(), (INDArray[])p.getSecond());
    }

    public static Pair<INDArray, INDArray> merge4d(INDArray[] arrays, INDArray[] masks) {
        int nExamples = 0;
        int[] shape = arrays[0].shape();
        INDArray[] temp = new INDArray[arrays.length];
        boolean hasMasks = false;
        for (int i = 0; i < arrays.length; ++i) {
            nExamples += arrays[i].size(0);
            int[] thisShape = arrays[i].shape();
            if (thisShape.length != 4) {
                throw new IllegalStateException("Cannot merge 4d arrays with non 4d arrays");
            }
            for (int j = 1; j < 4; ++j) {
                if (thisShape[j] == shape[j]) continue;
                throw new IllegalStateException("Cannot merge 4d arrays with different shape (other than # examples):  data[0].shape = " + Arrays.toString(shape) + ", data[" + i + "].shape = " + Arrays.toString(thisShape));
            }
            temp[i] = arrays[i];
            if (masks == null || masks[i] == null || masks[i] == null) continue;
            hasMasks = true;
            if (masks[i].rank() == 2) continue;
            throw new UnsupportedOperationException("Cannot merged 4d arrays with masks that are not rank 2. Got mask array with rank: " + masks[i].rank());
        }
        INDArray out = Nd4j.specialConcat(0, temp);
        INDArray outMask = null;
        if (hasMasks) {
            outMask = DataSetUtil.mergePerOutputMasks2d(out.shape(), arrays, masks);
        }
        return new Pair((Object)out, outMask);
    }
}

