/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.convolution;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class OldConvolution {
    private OldConvolution() {
    }

    public static INDArray col2im(INDArray col, int[] stride, int[] padding, int height, int width) {
        return OldConvolution.col2im(col, stride[0], stride[1], padding[0], padding[1], height, width);
    }

    public static INDArray col2im(INDArray col, int sy, int sx, int ph, int pw, int h, int w) {
        int n = col.size(0);
        int c = col.size(1);
        int kh = col.size(2);
        int kw = col.size(3);
        int outH = col.size(4);
        int outW = col.size(5);
        INDArray img = Nd4j.create(n, c, h + 2 * ph + sy - 1, w + 2 * pw + sx - 1);
        for (int i = 0; i < kh; ++i) {
            int iLim = i + sy * outH;
            for (int j = 0; j < kw; ++j) {
                int jLim = j + sx * outW;
                INDArrayIndex[] indices = new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)i, (long)sy, iLim), NDArrayIndex.interval((long)j, (long)sx, jLim)};
                INDArray get = img.get(indices);
                INDArray colAdd = col.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.point(i), NDArrayIndex.point(j), NDArrayIndex.all(), NDArrayIndex.all());
                get.addi(colAdd);
                img.put(indices, get);
            }
        }
        return img.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval(ph, ph + h), NDArrayIndex.interval(pw, pw + w));
    }

    public static INDArray im2col(INDArray img, int[] kernel, int[] stride, int[] padding) {
        return OldConvolution.im2col(img, kernel[0], kernel[1], stride[0], stride[1], padding[0], padding[1], 0, false);
    }

    public static INDArray im2col(INDArray img, int kh, int kw, int sy, int sx, int ph, int pw, int pval, boolean coverAll) {
        int n = img.size(0);
        int c = img.size(1);
        int h = img.size(2);
        int w = img.size(3);
        int outHeight = OldConvolution.outSize(h, kh, sy, ph, coverAll);
        int outWidth = OldConvolution.outSize(w, kw, sx, pw, coverAll);
        INDArray padded = Nd4j.pad(img, new int[][]{{0, 0}, {0, 0}, {ph, ph + sy - 1}, {pw, pw + sx - 1}}, Nd4j.PadMode.CONSTANT);
        INDArray ret = Nd4j.create(n, c, kh, kw, outHeight, outWidth);
        for (int i = 0; i < kh; ++i) {
            int iLim = i + sy * outHeight;
            for (int j = 0; j < kw; ++j) {
                int jLim = j + sx * outWidth;
                INDArray get = padded.get(NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)i, (long)sy, iLim), NDArrayIndex.interval((long)j, (long)sx, jLim));
                ret.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.point(i), NDArrayIndex.point(j), NDArrayIndex.all(), NDArrayIndex.all()}, get);
            }
        }
        return ret;
    }

    public static int outSize(int size, int k, int s, int p, boolean coverAll) {
        if (coverAll) {
            return (size + p * 2 - k + s - 1) / s + 1;
        }
        return (size + p * 2 - k) / s + 1;
    }
}

