/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class JaccardDistance
extends BaseAccumulation {
    private Number constantNormalizedByNorm2X;
    private Number constantNormalizedByNorm2Y;

    public JaccardDistance() {
        this.passThrough = true;
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x, INDArray y, long n) {
        super(x, y, n);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x) {
        super(x);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x, INDArray y) {
        super(x, y);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, boolean allDistances) {
        this(x, y, z, x.lengthLong());
        this.isComplex = allDistances;
    }

    public JaccardDistance(INDArray x, INDArray y, boolean allDistances) {
        this(x, y);
        this.isComplex = allDistances;
    }

    @Override
    public double update(double accum, double x) {
        return accum + x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x * y;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x * y;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.add((Number)x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add((Number)(x * y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x.mul(y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x.mul((Number)y));
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public String name() {
        return "jaccarddistance";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.mul((Number)other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.mul((Number)Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.mul(other);
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        JaccardDistance ret = this.y() != null ? new JaccardDistance(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length()) : new JaccardDistance(this.x.vectorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xForDimesnion = this.x.tensorAlongDimension(index, dimension);
        JaccardDistance ret = this.y() != null ? new JaccardDistance(xForDimesnion, this.y.tensorAlongDimension(index, dimension), xForDimesnion.length()) : new JaccardDistance(this.x.tensorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public void exec() {
        this.constantNormalizedByNorm2X = this.x.norm2Number();
        this.constantNormalizedByNorm2Y = this.y.norm2Number();
        this.extraArgs = new Object[]{0.0, this.constantNormalizedByNorm2X, this.constantNormalizedByNorm2Y};
        double dot = Nd4j.getBlasWrapper().dot(this.x, this.y);
        this.finalResult = dot / (this.constantNormalizedByNorm2X.doubleValue() * this.constantNormalizedByNorm2Y.doubleValue());
    }

    @Override
    public void exec(int ... dimension) {
        int[] retShape = ArrayUtil.removeIndex((int[])this.x.shape(), (int[])dimension);
        int nOps = this.x.tensorssAlongDimension(dimension);
        this.z = Nd4j.create(retShape);
        for (int i = 0; i < nOps; ++i) {
            double d = Nd4j.getExecutioner().execAndReturn((JaccardDistance)this.opForDimension(i, dimension)).getFinalResult().doubleValue();
            this.z.putScalar(i, d);
        }
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        if (this.applyFinalTransform()) {
            double d = accum / (this.constantNormalizedByNorm2X.doubleValue() * this.constantNormalizedByNorm2Y.doubleValue());
            this.finalResult = d;
            return d;
        }
        return accum;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        return (float)this.getAndSetFinalResult((double)accum);
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = Nd4j.createComplexNumber(accum.realComponent().doubleValue() / (this.constantNormalizedByNorm2X.doubleValue() * this.constantNormalizedByNorm2Y.doubleValue()), 0);
        return this.finalResultComplex;
    }

    @Override
    public double calculateFinalResult(double accum, long n) {
        throw new UnsupportedOperationException("Not supported for passthrough op");
    }

    @Override
    public float calculateFinalResult(float accum, long n) {
        throw new UnsupportedOperationException("Not supported for passthrough op");
    }
}

