/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class Mmul
extends BaseAccumulation {
    public Mmul() {
    }

    public Mmul(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Mmul(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Mmul(INDArray x) {
        super(x);
    }

    public Mmul(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int opNum() {
        return 3;
    }

    @Override
    public String name() {
        return "mmul";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long n() {
        return 0L;
    }

    @Override
    public boolean isPassThrough() {
        return true;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.mul((Number)other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.mul((Number)Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.mul(other);
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public double update(double accum, double x) {
        return accum + x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x * y;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x * y;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.add((Number)x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add((Number)(x * y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x.mul(y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x.mul((Number)y));
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public void exec() {
        if (this.z != null) {
            this.x.mmul(this.y, this.z);
        } else {
            this.z = this.x.mmul(this.y);
        }
    }
}

