/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.aggregates.impl;

import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.aggregates.BaseAggregate;
import org.nd4j.linalg.factory.Nd4j;

public class AggregateAxpy
extends BaseAggregate {
    private int vectorLength;

    public AggregateAxpy(@NonNull INDArray x, @NonNull INDArray y, double alpha) {
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
        this.arguments.add(x);
        this.arguments.add(y);
        this.indexingArguments.add(x.length());
        this.realArguments.add(alpha);
        this.vectorLength = x.length();
    }

    @Override
    public int getSharedMemorySize() {
        return this.getThreadsPerInstance() * Nd4j.sizeOfDataType() + 256;
    }

    @Override
    public int getThreadsPerInstance() {
        return Math.min(768, this.vectorLength);
    }

    @Override
    public String name() {
        return "aggregate_axpy";
    }

    @Override
    public int opNum() {
        return 2;
    }

    @Override
    public int maxArguments() {
        return 2;
    }

    @Override
    public int maxShapes() {
        return 0;
    }

    @Override
    public int maxIntArrays() {
        return 0;
    }

    @Override
    public int maxIntArraySize() {
        return 0;
    }

    @Override
    public int maxIndexArguments() {
        return 2;
    }

    @Override
    public int maxRealArguments() {
        return 2;
    }
}

