/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.ShapeInfoProvider;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseShapeInfoProvider
implements ShapeInfoProvider {
    protected AtomicLong bytes = new AtomicLong(0L);

    @Override
    public Pair<DataBuffer, int[]> createShapeInformation(int[] shape) {
        char order = Nd4j.order().charValue();
        return this.createShapeInformation(shape, order);
    }

    @Override
    public Pair<DataBuffer, int[]> createShapeInformation(int[] shape, char order) {
        int[] stride = Nd4j.getStrides(shape, order);
        int ews = 1;
        return this.createShapeInformation(shape, stride, 0L, ews, order);
    }

    @Override
    public Pair<DataBuffer, int[]> createShapeInformation(int[] shape, int[] stride, long offset, int elementWiseStride, char order) {
        DataBuffer buffer = Shape.createShapeInformation(shape, stride, offset, elementWiseStride, order);
        buffer.setConstant(true);
        return Pair.create((Object)buffer, (Object)buffer.asInt());
    }

    @Override
    public long getCachedBytes() {
        return this.bytes.get();
    }
}

