/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.nd4j.linalg.api.blas.Blas;
import org.nd4j.linalg.api.blas.Lapack;
import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.Level2;
import org.nd4j.linalg.api.blas.Level3;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;

public abstract class BaseNDArrayFactory
implements NDArrayFactory {
    protected char order;
    protected Blas blas;
    protected Level1 level1;
    protected Level2 level2;
    protected Level3 level3;
    protected Lapack lapack;

    public BaseNDArrayFactory() {
    }

    @Override
    public Lapack lapack() {
        if (this.lapack == null) {
            this.createLapack();
        }
        return this.lapack;
    }

    @Override
    public Blas blas() {
        if (this.blas == null) {
            this.createBlas();
        }
        return this.blas;
    }

    @Override
    public Level1 level1() {
        if (this.level1 == null) {
            this.createLevel1();
        }
        return this.level1;
    }

    @Override
    public Level2 level2() {
        if (this.level2 == null) {
            this.createLevel2();
        }
        return this.level2;
    }

    @Override
    public Level3 level3() {
        if (this.level3 == null) {
            this.createLevel3();
        }
        return this.level3;
    }

    protected BaseNDArrayFactory(DataBuffer.Type dtype, Character order) {
        if (Character.toLowerCase(order.charValue()) != 'c' && Character.toLowerCase(order.charValue()) != 'f') {
            throw new IllegalArgumentException("Order must either be c or f");
        }
        this.order = order.charValue();
    }

    protected BaseNDArrayFactory(DataBuffer.Type dtype, char order) {
        if (Character.toLowerCase(order) != 'c' && Character.toLowerCase(order) != 'f') {
            throw new IllegalArgumentException("Order must either be c or f");
        }
        this.order = order;
    }

    protected static void validateConcat(int dimension, INDArray ... arrs) {
        if (arrs[0].isScalar()) {
            for (int i = 1; i < arrs.length; ++i) {
                if (arrs[i].isScalar()) continue;
                throw new IllegalArgumentException("All arrays must have same dimensions");
            }
        } else {
            int dims = arrs[0].shape().length;
            int[] shape = ArrayUtil.removeIndex((int[])arrs[0].shape(), (int)dimension);
            for (int i = 1; i < arrs.length; ++i) {
                assert (Arrays.equals(shape, ArrayUtil.removeIndex((int[])arrs[i].shape(), (int)dimension)));
                assert (arrs[i].shape().length == dims);
            }
        }
    }

    @Override
    public void setOrder(char order) {
        assert (order == 'c' || order == 'f') : "Order specified must be either c or f";
        this.order = order;
    }

    @Override
    public INDArray rand(int[] shape, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(int rows, int columns, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return this.rand(new int[]{rows, columns}, min, max, rng);
    }

    @Override
    public void setDType(DataBuffer.Type dtype) {
        assert (dtype == DataBuffer.Type.DOUBLE || dtype == DataBuffer.Type.FLOAT || dtype == DataBuffer.Type.INT) : "Invalid type passed, must be float or double";
    }

    @Override
    public INDArray create(int[] shape, DataBuffer.Type dataType) {
        return this.create(shape, Nd4j.createBuffer(shape, dataType));
    }

    @Override
    public char order() {
        return this.order;
    }

    @Override
    public DataBuffer.Type dtype() {
        return Nd4j.dataType();
    }

    @Override
    public INDArray linspace(int lower, int upper, int num) {
        double[] data = new double[num];
        for (int i = 0; i < num; ++i) {
            double t = (double)i / (double)(num - 1);
            data[i] = (double)lower * (1.0 - t) + t * (double)upper;
        }
        INDArray ret = Nd4j.create(data.length);
        if (ret.isScalar()) {
            return ret;
        }
        for (int i = 0; i < ret.length(); ++i) {
            ret.putScalar(i, data[i]);
        }
        return ret;
    }

    @Override
    public IComplexNDArray createComplex(int[] ints, int[] ints1, int[] stride, int offset) {
        return this.createComplex(Nd4j.createBuffer(ints), ints1, stride, offset);
    }

    @Override
    public INDArray create(int[] ints, int[] ints1, int[] stride, int offset) {
        return this.create(Nd4j.createBuffer(ints), ints1, stride, offset);
    }

    @Override
    public INDArray create(int rows, int columns, char ordering) {
        return this.create(new int[]{rows, columns}, ordering);
    }

    @Override
    public INDArray toFlattened(Collection<INDArray> matrices) {
        int length = 0;
        for (INDArray m : matrices) {
            length += m.length();
        }
        INDArray ret = Nd4j.create(1, length);
        int linearIndex = 0;
        for (INDArray d : matrices) {
            ret.put(new INDArrayIndex[]{NDArrayIndex.interval(linearIndex, linearIndex + d.length())}, d);
            linearIndex += d.length();
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        ArrayList<INDArray> arr = new ArrayList<INDArray>();
        for (Iterator<? extends INDArray> arrs : matrices) {
            while (arrs.hasNext()) {
                arr.add(arrs.next());
            }
        }
        return this.toFlattened(arr);
    }

    @Override
    public INDArray bilinearProducts(INDArray curr, INDArray in) {
        assert (curr.shape().length == 3);
        if (in.columns() != 1) {
            throw new AssertionError((Object)"Expected a column vector");
        }
        if (in.rows() != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Number of rows in the input does not match number of columns in tensor");
        }
        if (curr.size(curr.shape().length - 2) != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Can only perform this operation on a SimpleTensor with square slices");
        }
        INDArray ret = Nd4j.create(curr.slices(), 1);
        INDArray inT = in.transpose();
        for (int i = 0; i < curr.slices(); ++i) {
            INDArray slice = curr.slice(i);
            INDArray inTTimesSlice = inT.mmul(slice);
            ret.putScalar(i, Nd4j.getBlasWrapper().dot(inTTimesSlice, in));
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(INDArray ... matrices) {
        int length = 0;
        for (INDArray m : matrices) {
            length += m.length();
        }
        INDArray ret = Nd4j.create(1, length);
        int linearIndex = 0;
        for (INDArray d : matrices) {
            ret.put(new INDArrayIndex[]{NDArrayIndex.interval(linearIndex, linearIndex + d.length())}, d);
            linearIndex += d.length();
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(char order, INDArray ... matrices) {
        return this.toFlattened(order, Arrays.asList(matrices));
    }

    @Override
    public INDArray eye(int n) {
        INDArray ret = Nd4j.create(n, n);
        for (int i = 0; i < n; ++i) {
            ret.put(i, i, 1.0);
        }
        return ret.reshape(n, n);
    }

    @Override
    public void rot90(INDArray toRotate) {
        if (!toRotate.isMatrix()) {
            throw new IllegalArgumentException("Only rotating matrices");
        }
        INDArray start = toRotate.transpose();
        for (int i = 0; i < start.rows(); ++i) {
            start.putRow(i, this.reverse(start.getRow(i)));
        }
    }

    @Override
    public INDArray rot(INDArray reverse) {
        INDArray ret = Nd4j.create(reverse.shape());
        if (reverse.isVector()) {
            return this.reverse(reverse);
        }
        for (int i = 0; i < reverse.slices(); ++i) {
            ret.putSlice(i, this.reverse(reverse.slice(i)));
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray reverse(INDArray reverse) {
        INDArray rev = reverse.linearView();
        INDArray ret = Nd4j.create(rev.shape());
        int count = 0;
        for (int i = rev.length() - 1; i >= 0; --i) {
            ret.putScalar(count++, rev.getFloat(i));
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray arange(double begin, double end) {
        return Nd4j.create(ArrayUtil.toDoubles((int[])ArrayUtil.range((int)((int)begin), (int)((int)end))));
    }

    @Override
    public abstract IComplexFloat createFloat(float var1, float var2);

    @Override
    public abstract IComplexDouble createDouble(double var1, double var3);

    @Override
    public void copy(INDArray a, INDArray b) {
        b.assign(a);
    }

    @Override
    public INDArray rand(int[] shape, float min, float max, Random rng) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(int rows, int columns, float min, float max, Random rng) {
        return this.rand(new int[]{rows, columns}, min, max, rng);
    }

    @Override
    public INDArray appendBias(INDArray ... vectors) {
        int size = 0;
        for (INDArray vector : vectors) {
            size += vector.rows();
        }
        INDArray result = Nd4j.create(size + 1, vectors[0].columns());
        int index = 0;
        for (INDArray vector : vectors) {
            INDArray put = this.toFlattened(vector, Nd4j.ones(1));
            result.put(new INDArrayIndex[]{NDArrayIndex.interval(index, index + vector.rows() + 1), NDArrayIndex.interval(0, vectors[0].columns())}, put);
            index += vector.rows();
        }
        return result;
    }

    @Override
    public abstract IComplexNDArray createComplex(INDArray var1);

    @Override
    public abstract IComplexNDArray createComplex(IComplexNumber[] var1, int[] var2);

    @Override
    public abstract IComplexNDArray createComplex(List<IComplexNDArray> var1, int[] var2);

    @Override
    public INDArray rand(int rows, int columns, Random r) {
        return this.rand(new int[]{rows, columns}, r);
    }

    @Override
    public INDArray rand(int rows, int columns, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(new int[]{rows, columns}, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(int rows, int columns) {
        return this.rand(new int[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(char order, int rows, int columns) {
        return Nd4j.getRandom().nextDouble(order, new int[]{rows, columns});
    }

    @Override
    public INDArray randn(int rows, int columns, Random r) {
        return this.randn(new int[]{rows, columns}, r);
    }

    @Override
    public INDArray randn(int rows, int columns) {
        return this.randn(new int[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(char order, int rows, int columns) {
        return Nd4j.getRandom().nextGaussian(order, new int[]{rows, columns});
    }

    @Override
    public INDArray randn(int rows, int columns, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(new int[]{rows, columns}, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(int[] shape, Distribution r) {
        INDArray ret = r.sample(shape);
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, Random r) {
        INDArray ret = r.nextDouble(shape);
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(int[] shape) {
        return this.rand(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(char order, int[] shape) {
        return Nd4j.getRandom().nextDouble(order, shape);
    }

    @Override
    public INDArray randn(int[] shape, Random r) {
        return r.nextGaussian(shape);
    }

    @Override
    public INDArray randn(char order, int[] shape) {
        return Nd4j.getRandom().nextGaussian(order, shape);
    }

    @Override
    public INDArray randn(int[] shape) {
        return this.randn(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray create(double[] data) {
        return this.create(data, new int[]{1, data.length});
    }

    @Override
    public INDArray create(float[] data) {
        return this.create(data, new int[]{1, data.length});
    }

    @Override
    public IComplexNDArray createComplex(double[] data) {
        assert (data.length % 2 == 0) : "Length of data must be even. A complex ndarray is made up of pairs of real and imaginary components";
        return this.createComplex(data, new int[]{1, data.length / 2});
    }

    @Override
    public INDArray create(int columns) {
        return this.create(new int[]{1, columns});
    }

    @Override
    public IComplexNDArray createComplex(int columns) {
        return this.createComplex(new int[]{1, columns});
    }

    @Override
    public INDArray zeros(int rows, int columns) {
        return this.zeros(new int[]{rows, columns});
    }

    @Override
    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order) {
        int vectorLength = source.shape()[sourceDimension];
        INDArray ret = Nd4j.createUninitialized(new int[]{indexes.length, vectorLength}, order);
        for (int cnt = 0; cnt < indexes.length; ++cnt) {
            ret.putRow(cnt, source.tensorAlongDimension(indexes[cnt], sourceDimension));
        }
        return ret;
    }

    @Override
    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        return this.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    @Override
    public IComplexNDArray complexZeros(int rows, int columns) {
        return this.createComplex(new int[]{rows, columns});
    }

    @Override
    public INDArray zeros(int columns) {
        return this.zeros(new int[]{1, columns});
    }

    @Override
    public IComplexNDArray complexZeros(int columns) {
        return this.createComplex(new int[]{1, columns});
    }

    @Override
    public IComplexNDArray complexValueOf(int[] shape, IComplexNumber value) {
        IComplexNDArray ones = this.complexOnes(shape);
        ones.assign(Nd4j.scalar(value));
        return ones;
    }

    @Override
    public IComplexNDArray complexValueOf(int num, double value) {
        IComplexNDArray ones = this.complexOnes(num);
        ones.assign((IComplexNumber)Nd4j.createDouble(value, 0.0));
        return ones;
    }

    @Override
    public IComplexNDArray complexValueOf(int[] shape, double value) {
        IComplexNDArray ones = this.complexOnes(shape);
        ones.assign(Nd4j.scalar(value));
        return ones;
    }

    @Override
    public IComplexNDArray complexValueOf(int num, IComplexNumber value) {
        IComplexNDArray ones = this.complexOnes(num);
        ones.assign(Nd4j.scalar(value));
        return ones;
    }

    @Override
    public IComplexNDArray createComplex(int[] shape, int[] complexStrides, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.createComplex(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape) * 2L), shape, complexStrides, offset, ordering);
    }

    @Override
    public INDArray valueArrayOf(int[] shape, double value) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        ret.assign(value);
        return ret;
    }

    @Override
    public INDArray create(int[] shape, int[] stride, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape)), shape, stride, offset, ordering);
    }

    @Override
    public INDArray valueArrayOf(int rows, int columns, double value) {
        INDArray create = this.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        create.assign(value);
        return create;
    }

    @Override
    public INDArray ones(int rows, int columns) {
        return this.ones(new int[]{rows, columns});
    }

    @Override
    public IComplexNDArray complexOnes(int rows, int columns) {
        return this.complexOnes(new int[]{rows, columns});
    }

    @Override
    public INDArray ones(int columns) {
        return this.ones(new int[]{1, columns});
    }

    @Override
    public IComplexNDArray complexOnes(int columns) {
        IComplexNDArray base = this.createComplex(new int[]{1, columns});
        base.assign(1);
        return base;
    }

    @Override
    public INDArray create(float[] data, int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(Nd4j.createBuffer(data), shape, Nd4j.getStrides(shape, ordering), 0, ordering);
    }

    @Override
    public INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        int sumAlongDim = 0;
        boolean allC = toConcat[0].ordering() == 'c';
        int[] outputShape = ArrayUtil.copy((int[])toConcat[0].shape());
        outputShape[dimension] = sumAlongDim;
        for (int i = 0; i < toConcat.length; ++i) {
            sumAlongDim += toConcat[i].size(dimension);
            allC = allC && toConcat[i].ordering() == 'c';
            for (int j = 0; j < toConcat[i].rank(); ++j) {
                if (j == dimension || toConcat[i].size(j) == outputShape[j] || toConcat[i].isVector()) continue;
                throw new IllegalArgumentException("Illegal concatneation at array " + i + " and shape element " + j);
            }
        }
        int[] sortedStrides = Nd4j.getStrides(outputShape);
        INDArray ret = Nd4j.create(outputShape, sortedStrides);
        allC &= ret.ordering() == 'c';
        if (toConcat[0].isScalar()) {
            INDArray retLinear = ret.linearView();
            for (int i = 0; i < retLinear.length(); ++i) {
                retLinear.putScalar(i, toConcat[i].getDouble(0));
            }
            return ret;
        }
        if (dimension == 0 && allC) {
            int currBuffer = 0;
            int currBufferOffset = 0;
            for (int i = 0; i < ret.length(); ++i) {
                ret.data().put((long)i, toConcat[currBuffer].data().getDouble((long)(toConcat[currBuffer].offset() + currBufferOffset++)));
                if (currBufferOffset < toConcat[currBuffer].length()) continue;
                ++currBuffer;
                currBufferOffset = 0;
            }
            return ret;
        }
        int arrOffset = 0;
        INDArray[] retAlongDimensionArrays = new INDArray[ret.tensorssAlongDimension(dimension)];
        for (int i = 0; i < retAlongDimensionArrays.length; ++i) {
            retAlongDimensionArrays[i] = ret.tensorAlongDimension(i, dimension);
        }
        for (INDArray arr : toConcat) {
            int arrTensorLength = -1;
            if (arr.tensorssAlongDimension(dimension) != ret.tensorssAlongDimension(dimension)) {
                throw new IllegalStateException("Illegal concatenate. Tensors along dimension must be same length.");
            }
            for (int i = 0; i < arr.tensorssAlongDimension(dimension); ++i) {
                INDArray retLinear = retAlongDimensionArrays[i];
                INDArray arrTensor = arr.tensorAlongDimension(i, dimension);
                arrTensorLength = arrTensor.length();
                for (int j = 0; j < arrTensor.length(); ++j) {
                    int idx = j + arrOffset;
                    retLinear.putScalar(idx, arrTensor.getDouble(j));
                }
            }
            arrOffset += arrTensorLength;
        }
        return ret;
    }

    @Override
    public IComplexNDArray concat(int dimension, IComplexNDArray ... toConcat) {
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        BaseNDArrayFactory.validateConcat(dimension, toConcat);
        int sumAlongDim = 0;
        for (int i = 0; i < toConcat.length; ++i) {
            sumAlongDim += toConcat[i].shape()[dimension];
        }
        int[] outputShape = ArrayUtil.copy((int[])toConcat[0].shape());
        outputShape[dimension] = sumAlongDim;
        IComplexNDArray ret = Nd4j.createComplex(outputShape);
        IComplexNDArray linear = ret.linearView();
        int count = 0;
        for (int i = 0; i < toConcat.length; ++i) {
            IComplexNDArray flattened = toConcat[i].linearView();
            for (int j = 0; j < flattened.length(); ++j) {
                linear.putScalar(count++, flattened.getComplex(j));
            }
        }
        return ret;
    }

    @Override
    public IComplexNDArray complexFlatten(IComplexNDArray[] flatten) {
        int length = 0;
        for (IComplexNDArray m : flatten) {
            length += m.length();
        }
        IComplexNDArray ret = Nd4j.createComplex(length);
        int linearIndex = 0;
        for (IComplexNDArray d : flatten) {
            IComplexNDArray flattened = d.linearView();
            for (int i = 0; i < d.length(); ++i) {
                ret.putScalar(linearIndex++, flattened.getComplex(i));
            }
        }
        return ret;
    }

    @Override
    public IComplexNDArray complexFlatten(List<IComplexNDArray> flatten) {
        int length = 0;
        for (IComplexNDArray m : flatten) {
            length += m.length();
        }
        IComplexNDArray ret = Nd4j.createComplex(length);
        int linearIndex = 0;
        for (IComplexNDArray d : flatten) {
            IComplexNDArray flattened = d.linearView();
            for (int i = 0; i < d.length(); ++i) {
                ret.putScalar(linearIndex++, flattened.getComplex(i));
            }
        }
        return ret;
    }

    @Override
    public INDArray hstack(INDArray ... arrs) {
        return Nd4j.concat(1, arrs);
    }

    @Override
    public INDArray vstack(INDArray ... arrs) {
        return Nd4j.concat(0, arrs);
    }

    @Override
    public INDArray zeros(int[] shape) {
        INDArray ret = this.create(shape);
        return ret;
    }

    @Override
    public IComplexNDArray complexZeros(int[] shape) {
        IComplexNDArray ret = this.createComplex(shape);
        return ret;
    }

    @Override
    public INDArray ones(int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        INDArray ret = this.create(shape);
        ret.assign(1);
        return ret;
    }

    @Override
    public IComplexNDArray complexOnes(int[] shape) {
        IComplexNDArray ret = this.createComplex(shape);
        ret.assign(1);
        return ret;
    }

    @Override
    public IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset) {
        return this.createComplex(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public INDArray create(float[] data, int rows, int columns, int[] stride, int offset) {
        return this.create(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.createComplex(Nd4j.createBuffer(data), shape, stride, offset, Nd4j.order().charValue());
    }

    @Override
    public abstract INDArray create(float[] var1, int[] var2, int[] var3, int var4);

    @Override
    public INDArray create(double[] data, int[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0);
    }

    @Override
    public INDArray create(float[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(data, shape, Nd4j.getStrides(shape), 0);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.createComplex(data, shape, Nd4j.getComplexStrides(shape), 0);
    }

    @Override
    public IComplexNDArray createComplex(float[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.createComplex(data, shape, Nd4j.getComplexStrides(shape), 0);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.createComplex(data, shape, stride, 0);
    }

    @Override
    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride) {
        return this.createComplex(data, shape, stride, 0);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset) {
        return this.createComplex(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public INDArray create(double[] data, int rows, int columns, int[] stride, int offset) {
        return this.create(data, new int[]{rows, columns}, stride, offset);
    }

    @Override
    public abstract IComplexNDArray createComplex(double[] var1, int[] var2, int[] var3, int var4);

    @Override
    public abstract INDArray create(double[] var1, int[] var2, int[] var3, int var4);

    @Override
    public abstract INDArray create(List<INDArray> var1, int[] var2);

    @Override
    public IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.createComplex(new double[rows * columns * 2], new int[]{rows, columns}, stride, offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.createComplex(new float[rows * columns * 2], new int[]{rows, columns}, stride, offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.INT) {
            return this.createComplex(new int[rows * columns * 2], new int[]{rows, columns}, stride, offset);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public INDArray create(int rows, int columns, int[] stride, int offset) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.create(new double[rows * columns], new int[]{rows, columns}, stride, offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.create(new float[rows * columns], new int[]{rows, columns}, stride, offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.INT) {
            return this.create(new int[rows * columns], new int[]{rows, columns}, stride, offset);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public IComplexNDArray createComplex(int[] shape, int[] stride, int offset) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.createComplex(new double[ArrayUtil.prod((int[])shape) * 2], shape, stride, offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.createComplex(new float[ArrayUtil.prod((int[])shape) * 2], shape, stride, offset);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public INDArray create(int[] shape, int[] stride, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        DataBuffer buffer = Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape));
        return this.create(buffer, shape, stride, offset);
    }

    @Override
    public IComplexNDArray createComplex(int rows, int columns, int[] stride) {
        return this.createComplex(new int[]{rows, columns}, stride);
    }

    @Override
    public INDArray create(int rows, int columns, int[] stride) {
        return this.create(new int[]{rows, columns}, stride);
    }

    @Override
    public IComplexNDArray createComplex(int[] shape, int[] stride) {
        return this.createComplex(shape, stride, 0);
    }

    @Override
    public INDArray create(int[] shape, int[] stride) {
        return this.create(shape, stride, 0);
    }

    @Override
    public IComplexNDArray createComplex(int rows, int columns) {
        return this.createComplex(new int[]{rows, columns});
    }

    @Override
    public INDArray create(int rows, int columns) {
        return this.create(new int[]{rows, columns});
    }

    @Override
    public IComplexNDArray createComplex(int[] shape) {
        return this.createComplex(shape, Nd4j.getComplexStrides(shape), 0);
    }

    @Override
    public INDArray create(int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(shape, Nd4j.getStrides(shape), 0);
    }

    @Override
    public INDArray scalar(Number value, int offset) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar(value.doubleValue(), offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.scalar(value.floatValue(), offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.INT) {
            return this.scalar(value.intValue(), offset);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public IComplexNDArray complexScalar(Number value, int offset) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar(this.createDouble(value.doubleValue(), 0.0), offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.INT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.scalar(this.createFloat(value.floatValue(), 0.0f), offset);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public IComplexNDArray complexScalar(Number value) {
        return this.complexScalar(value, 0);
    }

    @Override
    public INDArray scalar(float value, int offset) {
        return this.create(new float[]{value}, new int[]{1, 1}, new int[]{1, 1}, offset);
    }

    @Override
    public INDArray scalar(double value, int offset) {
        return this.create(new double[]{value}, new int[]{1, 1}, new int[]{1, 1}, offset);
    }

    @Override
    public INDArray scalar(int value, int offset) {
        return this.create(new int[]{value}, new int[]{1, 1}, new int[]{1, 1}, offset);
    }

    @Override
    public INDArray scalar(Number value) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar(value.doubleValue(), 0);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.scalar(value.floatValue(), 0);
        }
        if (Nd4j.dataType() == DataBuffer.Type.INT) {
            return this.scalar(value.intValue(), 0);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public INDArray scalar(float value) {
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.create(new float[]{value}, new int[]{1, 1}, new int[]{1, 1}, 0);
        }
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar((double)value);
        }
        return this.scalar((int)value);
    }

    @Override
    public INDArray scalar(double value) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.create(new double[]{value}, new int[]{1, 1}, new int[]{1, 1}, 0);
        }
        return this.scalar((float)value);
    }

    @Override
    public IComplexNDArray scalar(IComplexNumber value, int offset) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar(value.asDouble(), offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.scalar(value.asFloat(), offset);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public IComplexNDArray scalar(IComplexFloat value) {
        return this.createComplex(new float[]{value.realComponent().floatValue(), value.imaginaryComponent().floatValue()}, new int[]{1}, new int[]{1}, 0);
    }

    @Override
    public IComplexNDArray scalar(IComplexDouble value) {
        return this.createComplex(new double[]{value.realComponent(), value.imaginaryComponent()}, new int[]{1}, new int[]{1}, 0);
    }

    @Override
    public IComplexNDArray scalar(IComplexNumber value) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar(value.asDouble(), 0);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.scalar(value.asFloat(), 0);
        }
        throw new IllegalStateException("Illegal data type " + Nd4j.dataType());
    }

    @Override
    public IComplexNDArray scalar(IComplexFloat value, int offset) {
        return this.createComplex(new float[]{value.realComponent().floatValue(), value.imaginaryComponent().floatValue()}, new int[]{1}, new int[]{1}, offset);
    }

    @Override
    public IComplexNDArray scalar(IComplexDouble value, int offset) {
        return this.createComplex(new double[]{value.realComponent(), value.imaginaryComponent()}, new int[]{1}, new int[]{1}, offset);
    }

    @Override
    public abstract IComplexNDArray createComplex(double[] var1, int[] var2, int[] var3, int var4, char var5);

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape, int offset, char ordering) {
        return this.createComplex(Nd4j.createBuffer(data), shape, offset, ordering);
    }

    @Override
    public IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return this.createComplex(Nd4j.createBuffer(data), shape, offset);
    }

    @Override
    public INDArray create(float[] data, int[] shape, int offset) {
        return this.create(Nd4j.createBuffer(data), shape, offset);
    }

    @Override
    public INDArray create(float[] data, char order) {
        int[] shape = new int[]{1, data.length};
        return this.create(Nd4j.createBuffer(data), shape, Nd4j.getStrides(shape, order), order, 0);
    }

    @Override
    public INDArray create(float[] data, int[] shape, int[] stride, char order, int offset) {
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }

    @Override
    public INDArray create(double[] data, char order) {
        return this.create(data, new int[]{1, data.length}, Nd4j.getStrides(new int[]{1, data.length}, order), order, 0);
    }

    @Override
    public INDArray create(double[] data, int[] shape, int[] stride, char order, int offset) {
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }

    @Override
    public INDArray create(DataBuffer buffer, int[] shape, int[] stride, char order, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(buffer, shape, stride, offset, order);
    }

    @Override
    public INDArray create(int[] data, int[] shape, int[] stride, char order, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }
}

