/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator;

import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.cache.DataSetCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDataSetIterator
implements DataSetIterator {
    private static final Logger log = LoggerFactory.getLogger(DataSetCache.class);
    private DataSetIterator sourceIterator;
    private DataSetCache cache;
    private DataSetPreProcessor preProcessor;
    private String namespace;
    private int currentIndex = 0;
    private boolean usingCache = false;
    private boolean allowPrefetching;

    public CachingDataSetIterator(DataSetIterator sourceIterator, DataSetCache cache, String namespace) {
        this(sourceIterator, cache, namespace, false);
    }

    public CachingDataSetIterator(DataSetIterator sourceIterator, DataSetCache cache, String namespace, boolean allowPrefetching) {
        this.sourceIterator = sourceIterator;
        this.cache = cache;
        this.preProcessor = null;
        this.namespace = namespace;
        this.currentIndex = 0;
        this.usingCache = cache.isComplete(namespace);
        this.allowPrefetching = allowPrefetching;
    }

    public CachingDataSetIterator(DataSetIterator sourceIterator, DataSetCache cache) {
        this(sourceIterator, cache, "default");
    }

    private String makeKey(int index) {
        return String.format("data-set-cache-%s-%06d.bin", this.namespace, index);
    }

    @Override
    public DataSet next(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalExamples() {
        return this.sourceIterator.totalExamples();
    }

    @Override
    public int inputColumns() {
        return this.sourceIterator.inputColumns();
    }

    @Override
    public int totalOutcomes() {
        return this.sourceIterator.totalOutcomes();
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return this.allowPrefetching;
    }

    @Override
    public void reset() {
        this.sourceIterator.reset();
        this.currentIndex = 0;
    }

    @Override
    public int batch() {
        return this.sourceIterator.numExamples();
    }

    @Override
    public int cursor() {
        return this.currentIndex;
    }

    @Override
    public int numExamples() {
        return this.sourceIterator.numExamples();
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public List<String> getLabels() {
        return this.sourceIterator.getLabels();
    }

    @Override
    public boolean hasNext() {
        if (this.usingCache) {
            return this.cache.contains(this.makeKey(this.currentIndex));
        }
        if (this.sourceIterator.hasNext()) {
            return true;
        }
        this.usingCache = true;
        this.cache.setComplete(this.namespace, true);
        return false;
    }

    @Override
    public DataSet next() {
        DataSet ds;
        String key = this.makeKey(this.currentIndex);
        if (this.usingCache) {
            ds = this.cache.get(key);
        } else {
            ds = (DataSet)this.sourceIterator.next();
            this.cache.put(key, ds);
        }
        ++this.currentIndex;
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(ds);
        }
        return ds;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

