/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cache;

import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TadDescriptor {
    private static Logger logger = LoggerFactory.getLogger(TadDescriptor.class);
    private int dimensionLength;
    private int[] dimension;
    private int[] shape;

    public TadDescriptor(INDArray array, int[] dimension) {
        this.dimensionLength = dimension == null ? 0 : dimension.length;
        this.dimension = dimension;
        this.shape = TadDescriptor.dataBufferToArray(array.shapeInfoDataBuffer());
    }

    public static int[] dataBufferToArray(DataBuffer buffer) {
        int rank = buffer.getInt(0L);
        int[] ret = new int[rank * 2 + 4];
        ret[0] = rank;
        for (int e = 1; e < rank * 2 + 4; ++e) {
            ret[e] = buffer.getInt((long)e);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TadDescriptor that = (TadDescriptor)o;
        if (this.dimensionLength != that.dimensionLength) {
            return false;
        }
        if (!Arrays.equals(this.dimension, that.dimension)) {
            return false;
        }
        return Arrays.equals(this.shape, that.shape);
    }

    public int hashCode() {
        int result = this.dimensionLength;
        result = 31 * result + Arrays.hashCode(this.dimension);
        result = 31 * result + Arrays.hashCode(this.shape);
        return result;
    }
}

