/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations;

import java.util.HashMap;
import java.util.Map;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationCube;
import org.nd4j.linalg.activations.impl.ActivationELU;
import org.nd4j.linalg.activations.impl.ActivationHardSigmoid;
import org.nd4j.linalg.activations.impl.ActivationHardTanH;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.activations.impl.ActivationLReLU;
import org.nd4j.linalg.activations.impl.ActivationRReLU;
import org.nd4j.linalg.activations.impl.ActivationReLU;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;
import org.nd4j.linalg.activations.impl.ActivationSoftPlus;
import org.nd4j.linalg.activations.impl.ActivationSoftSign;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.activations.impl.ActivationTanH;

public enum Activation {
    CUBE,
    ELU,
    HARDSIGMOID,
    HARDTANH,
    IDENTITY,
    LEAKYRELU,
    RELU,
    RRELU,
    SIGMOID,
    SOFTMAX,
    SOFTPLUS,
    SOFTSIGN,
    TANH;

    private static final Map<String, Activation> nameMap;

    private static Map<String, Activation> initNameMap() {
        HashMap<String, Activation> map = new HashMap<String, Activation>();
        for (Activation a : Activation.values()) {
            map.put(a.name().toLowerCase(), a);
        }
        return map;
    }

    public IActivation getActivationFunction() {
        switch (this) {
            case CUBE: {
                return new ActivationCube();
            }
            case ELU: {
                return new ActivationELU();
            }
            case HARDSIGMOID: {
                return new ActivationHardSigmoid();
            }
            case HARDTANH: {
                return new ActivationHardTanH();
            }
            case IDENTITY: {
                return new ActivationIdentity();
            }
            case LEAKYRELU: {
                return new ActivationLReLU();
            }
            case RELU: {
                return new ActivationReLU();
            }
            case RRELU: {
                return new ActivationRReLU();
            }
            case SIGMOID: {
                return new ActivationSigmoid();
            }
            case SOFTMAX: {
                return new ActivationSoftmax();
            }
            case SOFTPLUS: {
                return new ActivationSoftPlus();
            }
            case SOFTSIGN: {
                return new ActivationSoftSign();
            }
            case TANH: {
                return new ActivationTanH();
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported activation function: " + (Object)((Object)this));
    }

    public static Activation fromString(String name) {
        Activation a = nameMap.get(name.toLowerCase());
        if (a == null) {
            throw new RuntimeException("Unknown activation function: " + name);
        }
        return a;
    }

    static {
        nameMap = Activation.initNameMap();
    }
}

