/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.GradientUpdaterAggregator;

public class Sgd
implements GradientUpdater {
    private double learningRate = 0.1;

    public Sgd(double learningRate) {
        this.learningRate = learningRate;
    }

    @Override
    public int stateSizeForInputSize(int inputSize) {
        return 0;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, int[] gradientShape, char gradientOrder, boolean initialize) {
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        return gradient.muli(this.learningRate);
    }

    @Override
    public GradientUpdaterAggregator getAggregator(boolean addThis) {
        SgdAggregator ag = new SgdAggregator();
        if (addThis) {
            ag.aggregate(this);
        }
        return ag;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sgd)) {
            return false;
        }
        Sgd other = (Sgd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getLearningRate(), other.getLearningRate()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sgd;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        return result;
    }

    public String toString() {
        return "Sgd(learningRate=" + this.getLearningRate() + ")";
    }

    public Sgd() {
    }

    public static class SgdAggregator
    implements GradientUpdaterAggregator {
        private double lrSum;
        private int count = 0;

        @Override
        public GradientUpdater getUpdater() {
            return new Sgd(this.lrSum / (double)this.count);
        }

        @Override
        public void aggregate(GradientUpdater updater) {
            if (!(updater instanceof Sgd)) {
                throw new UnsupportedOperationException("Cannot aggregate Sgd with updater: " + updater);
            }
            Sgd sgd = (Sgd)updater;
            this.lrSum += sgd.learningRate;
            ++this.count;
        }

        @Override
        public GradientUpdaterAggregator combine(GradientUpdaterAggregator other) {
            if (!(other instanceof SgdAggregator)) {
                throw new IllegalArgumentException("Cannot combine SgdAggregator with aggregator: " + other);
            }
            SgdAggregator aggregator = (SgdAggregator)other;
            this.lrSum += aggregator.lrSum;
            this.count += aggregator.count;
            return this;
        }
    }
}

