/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.VectorFFT;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.FFTInstance;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public abstract class BaseFFTInstance
implements FFTInstance {
    @Override
    public IComplexNDArray fft(INDArray transform, int numElements) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(new VectorFFT((INDArray)inputC, inputC.length()));
        }
        return this.rawfft(inputC, numElements, inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray fft(IComplexNDArray inputC) {
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(new VectorFFT((INDArray)inputC, inputC.length()));
        }
        return this.rawfft(inputC, inputC.size(inputC.shape().length - 1), inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray fft(INDArray input) {
        IComplexNDArray inputC = Nd4j.createComplex(input);
        return this.fft(inputC);
    }

    @Override
    public IComplexNDArray fft(IComplexNDArray inputC, int numElements) {
        return this.fft(inputC, numElements, inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray ifftn(INDArray transform, int dimension, int numElements) {
        return this.ifftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    @Override
    public IComplexNDArray irfftn(IComplexNDArray arr) {
        int[] shape = arr.shape();
        IComplexNDArray ret = arr.dup();
        for (int i = 0; i < shape.length - 1; ++i) {
            ret = this.ifftn(ret, i, shape[i]);
        }
        return this.irfft(ret, 0);
    }

    @Override
    public IComplexNDArray irfft(IComplexNDArray arr, int dimension) {
        return this.fftn(arr, arr.size(dimension), dimension);
    }

    @Override
    public IComplexNDArray irfft(IComplexNDArray arr) {
        return arr;
    }

    @Override
    public IComplexNDArray ifftn(IComplexNDArray transform, int dimension, int numElements) {
        if (numElements < 1) {
            throw new IllegalArgumentException("No elements specified");
        }
        int[] finalShape = ArrayUtil.replace((int[])transform.shape(), (int)dimension, (int)numElements);
        int[] axes = ArrayUtil.range((int)0, (int)finalShape.length);
        IComplexNDArray result = transform.dup();
        int desiredElementsAlongDimension = result.size(dimension);
        if (numElements > desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.padWithZeros(result, finalShape);
        } else if (numElements < desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.truncate(result, numElements, dimension);
        }
        return this.rawifftn(result, finalShape, axes);
    }

    @Override
    public IComplexNDArray fftn(IComplexNDArray transform, int dimension, int numElements) {
        if (numElements < 1) {
            throw new IllegalArgumentException("No elements specified");
        }
        int[] finalShape = ArrayUtil.replace((int[])transform.shape(), (int)dimension, (int)numElements);
        int[] axes = ArrayUtil.range((int)0, (int)finalShape.length);
        IComplexNDArray result = transform.dup();
        int desiredElementsAlongDimension = result.size(dimension);
        if (numElements > desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.padWithZeros(result, finalShape);
        } else if (numElements < desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.truncate(result, numElements, dimension);
        }
        return this.rawfftn(result, finalShape, axes);
    }

    @Override
    public IComplexNDArray fftn(INDArray transform, int dimension, int numElements) {
        return this.fftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    @Override
    public IComplexNDArray fftn(INDArray transform) {
        return this.fftn(transform, transform.shape().length - 1, transform.shape()[transform.shape().length - 1]);
    }

    @Override
    public IComplexNDArray fftn(IComplexNDArray transform) {
        return this.rawfftn(transform, null, null);
    }

    @Override
    public IComplexNDArray ifftn(IComplexNDArray transform, int dimension) {
        return this.ifftn(transform, dimension, transform.shape()[dimension]);
    }

    @Override
    public IComplexNDArray ifftn(IComplexNDArray transform) {
        return this.rawifftn(transform, null, null);
    }

    @Override
    public IComplexNDArray ifftn(INDArray transform) {
        return this.ifftn(transform, transform.shape().length - 1, transform.size(transform.shape().length - 1));
    }

    @Override
    public IComplexNDArray rawifftn(IComplexNDArray transform, int[] shape, int[] axes) {
        return this.doFFt(transform, shape, axes, true);
    }

    @Override
    public IComplexNDArray rawfftn(IComplexNDArray transform, int[] shape, int[] axes) {
        return this.doFFt(transform, shape, axes, false);
    }

    private IComplexNDArray fixShape(IComplexNDArray x, int[] shape, int axis, int n) {
        if (shape[axis] <= n) {
            int[] newShape = ArrayUtil.copy((int[])shape);
            newShape[axis] = n;
            x = ComplexNDArrayUtil.padWithZeros(x, newShape);
            return x;
        }
        int[] newShape = ArrayUtil.copy((int[])shape);
        newShape[axis] = n;
        x = ComplexNDArrayUtil.truncate(x, n, axis);
        return x;
    }

    @Override
    public IComplexNDArray rawifft(IComplexNDArray transform, int dimension) {
        return this.rawifft(transform, transform.shape()[dimension], dimension);
    }

    protected IComplexNDArray doFFt(IComplexNDArray transform, int[] shape, int[] axes, boolean inverse) {
        IComplexNDArray result = transform.dup();
        if (shape == null) {
            shape = ArrayUtil.copy((int[])result.shape());
        }
        boolean noAxes = false;
        if (axes == null || axes.length < 1) {
            noAxes = true;
            axes = ArrayUtil.range((int)0, (int)shape.length);
            axes = ArrayUtil.reverseCopy((int[])axes);
        }
        if (noAxes) {
            for (int i : axes) {
                if (i < 0) {
                    i = shape.length + i;
                }
                transform = this.fixShape(transform, shape, i, shape[i]);
            }
        }
        if (ArrayUtil.prod((int[])shape) > ArrayUtil.prod((int[])result.shape())) {
            result = ComplexNDArrayUtil.padWithZeros(result, shape);
        }
        return this.doInnerFft(result, shape, axes, inverse);
    }

    protected IComplexNDArray doInnerFft(IComplexNDArray result, int[] shape, int[] axes, boolean inverse) {
        for (int i = 0; i < axes.length; ++i) {
            result = inverse ? this.ifft(result, shape[axes[i]], axes[i]) : this.fft(result, shape[axes[i]], axes[i]);
        }
        return result;
    }
}

