/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator;

import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class SamplingDataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -2700563801361726914L;
    private DataSet sampleFrom;
    private int batchSize;
    private int totalNumberSamples;
    private int numTimesSampled;
    private boolean replace = false;
    private DataSetPreProcessor preProcessor;

    public SamplingDataSetIterator(DataSet sampleFrom, int batchSize, int totalNumberSamples, boolean replace) {
        this.sampleFrom = sampleFrom;
        this.batchSize = batchSize;
        this.totalNumberSamples = totalNumberSamples;
        this.replace = replace;
    }

    public SamplingDataSetIterator(DataSet sampleFrom, int batchSize, int totalNumberSamples) {
        this.sampleFrom = sampleFrom;
        this.batchSize = batchSize;
        this.totalNumberSamples = totalNumberSamples;
    }

    @Override
    public boolean hasNext() {
        return this.numTimesSampled < this.totalNumberSamples;
    }

    @Override
    public DataSet next() {
        DataSet ret = this.sampleFrom.sample(this.batchSize, this.replace);
        this.numTimesSampled += this.batchSize;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalExamples() {
        return this.totalNumberSamples * this.batchSize;
    }

    @Override
    public int inputColumns() {
        return this.sampleFrom.numInputs();
    }

    @Override
    public int totalOutcomes() {
        return this.sampleFrom.numOutcomes();
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return false;
    }

    @Override
    public void reset() {
        this.numTimesSampled = 0;
    }

    @Override
    public int batch() {
        return this.batchSize;
    }

    @Override
    public int cursor() {
        return this.numTimesSampled;
    }

    @Override
    public int numExamples() {
        return this.sampleFrom.numExamples();
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public DataSet next(int num) {
        DataSet ret = this.sampleFrom.sample(num);
        ++this.numTimesSampled;
        return ret;
    }
}

