/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar.comparison;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarSetValue
extends BaseScalarOp {
    public ScalarSetValue() {
    }

    public ScalarSetValue(INDArray x, INDArray y, INDArray z, long n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarSetValue(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarSetValue(INDArray x, INDArray y, INDArray z, long n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarSetValue(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    @Override
    public int opNum() {
        return 13;
    }

    @Override
    public String name() {
        return "setvalorless_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return this.setValueIfLess(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return this.setValueIfLess(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return this.setValueIfLess(origin);
    }

    @Override
    public float op(float origin, float other) {
        return origin < this.num.floatValue() ? this.num.floatValue() : origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin < this.num.doubleValue() ? (double)this.num.floatValue() : origin;
    }

    @Override
    public double op(double origin) {
        return origin < this.num.doubleValue() ? (double)this.num.floatValue() : origin;
    }

    @Override
    public float op(float origin) {
        return origin < this.num.floatValue() ? this.num.floatValue() : origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return this.setValueIfLess(origin);
    }

    private IComplexNumber setValueIfLess(IComplexNumber num) {
        if (num.realComponent().doubleValue() < this.num.doubleValue()) {
            return num.set((Number)this.num.doubleValue(), (Number)0.0);
        }
        return num;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarSetValue(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarSetValue(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.num != null) {
            return new ScalarSetValue(this.x.tensorAlongDimension(index, dimension), this.num);
        }
        return new ScalarSetValue(this.x.tensorAlongDimension(index, dimension), this.complexNumber);
    }
}

