/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.lang.reflect.Constructor;
import org.nd4j.linalg.api.rng.Random;

public class RandomFactory {
    private ThreadLocal<Random> threadRandom = new ThreadLocal();
    private Class randomClass;

    public RandomFactory(Class randomClass) {
        this.randomClass = randomClass;
    }

    public Random getRandom() {
        try {
            if (this.threadRandom.get() == null) {
                Random t = (Random)this.randomClass.newInstance();
                if (t.getStatePointer() != null) {
                    // empty if block
                }
                this.threadRandom.set(t);
                return t;
            }
            return this.threadRandom.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Random getNewRandomInstance() {
        return this.getNewRandomInstance(System.currentTimeMillis());
    }

    public Random getNewRandomInstance(long seed) {
        try {
            Random t = (Random)this.randomClass.newInstance();
            if (t.getStatePointer() != null) {
                // empty if block
            }
            t.setSeed(seed);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Random getNewRandomInstance(long seed, long size) {
        try {
            Class c = this.randomClass;
            Constructor constructor = c.getConstructor(Long.TYPE, Long.TYPE);
            Random t = (Random)constructor.newInstance(seed, size);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

