/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator;

import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.fetcher.DataSetFetcher;

public class BaseDatasetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -116636792426198949L;
    protected int batch;
    protected int numExamples;
    protected DataSetFetcher fetcher;
    protected DataSetPreProcessor preProcessor;

    public BaseDatasetIterator(int batch, int numExamples, DataSetFetcher fetcher) {
        this.batch = batch;
        if (numExamples < 0) {
            numExamples = fetcher.totalExamples();
        }
        this.numExamples = numExamples;
        this.fetcher = fetcher;
    }

    @Override
    public boolean hasNext() {
        return this.fetcher.hasMore() && this.fetcher.cursor() < this.numExamples;
    }

    @Override
    public DataSet next() {
        this.fetcher.fetch(this.batch);
        return this.fetcher.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalExamples() {
        return this.fetcher.totalExamples();
    }

    @Override
    public int inputColumns() {
        return this.fetcher.inputColumns();
    }

    @Override
    public int totalOutcomes() {
        return this.fetcher.totalOutcomes();
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return true;
    }

    @Override
    public void reset() {
        this.fetcher.reset();
    }

    @Override
    public int batch() {
        return this.batch;
    }

    @Override
    public int cursor() {
        return this.fetcher.cursor();
    }

    @Override
    public int numExamples() {
        return this.numExamples;
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public DataSet next(int num) {
        this.fetcher.fetch(num);
        DataSet next = this.fetcher.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(next);
        }
        return next;
    }
}

