/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class GaussianDistribution
extends BaseRandomOp {
    private double mean;
    private double stddev;

    public GaussianDistribution() {
    }

    public GaussianDistribution(INDArray z, double mean, double stddev) {
        this.init(z, z, z, z.length());
        this.mean = mean;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution(INDArray z, INDArray means, double stddev) {
        if (z.length() != means.length()) {
            throw new IllegalStateException("Result length should be equal to provided Means length");
        }
        if (means.elementWiseStride() < 1) {
            throw new IllegalStateException("Means array can't have negative EWS");
        }
        this.init(z, means, z, z.length());
        this.mean = 0.0;
        this.stddev = stddev;
        this.extraArgs = new Object[]{this.mean, this.stddev};
    }

    public GaussianDistribution(INDArray z) {
        this(z, 0.0, 1.0);
    }

    public GaussianDistribution(INDArray z, double stddev) {
        this(z, 0.0, stddev);
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public String name() {
        return "distribution_gaussian";
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }
}

