/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.inverse;

import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.checkutil.CheckUtil;

public class InvertMatrix {
    public static INDArray invert(INDArray arr, boolean inPlace) {
        if (!arr.isSquare()) {
            throw new IllegalArgumentException("invalid array: must be square matrix");
        }
        RealMatrix rm = CheckUtil.convertToApacheMatrix(arr);
        RealMatrix rmInverse = new LUDecomposition(rm).getSolver().getInverse();
        INDArray inverse = CheckUtil.convertFromApacheMatrix(rmInverse);
        if (inPlace) {
            arr.assign(inverse);
        }
        return inverse;
    }
}

