/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.conditions;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.BaseCondition;

public class EpsilonNotEquals
extends BaseCondition {
    public EpsilonNotEquals(Number value) {
        super(value);
    }

    public EpsilonNotEquals(IComplexNumber complexNumber) {
        super(complexNumber);
    }

    @Override
    public int condtionNum() {
        return 1;
    }

    @Override
    public Boolean apply(Number input) {
        return (double)Math.abs(input.floatValue() - this.value.floatValue()) < Nd4j.EPS_THRESHOLD;
    }

    @Override
    public Boolean apply(IComplexNumber input) {
        return (double)Math.abs(input.absoluteValue().floatValue() - input.absoluteValue().floatValue()) < Nd4j.EPS_THRESHOLD;
    }
}

