/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.compression;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class BasicNDArrayCompressor {
    private static final BasicNDArrayCompressor INSTANCE = new BasicNDArrayCompressor();
    protected Map<String, NDArrayCompressor> codecs;
    protected String defaultCompression = "FP16";

    private BasicNDArrayCompressor() {
        this.loadCompressors();
    }

    protected void loadCompressors() {
        this.codecs = new ConcurrentHashMap<String, NDArrayCompressor>();
        Reflections reflections = new Reflections("org.nd4j", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(NDArrayCompressor.class);
        for (Class impl : classes) {
            try {
                NDArrayCompressor compressor = (NDArrayCompressor)impl.newInstance();
                this.codecs.put(compressor.getDescriptor().toUpperCase(), compressor);
            }
            catch (InstantiationException compressor) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Set<String> getAvailableCompressors() {
        return this.codecs.keySet();
    }

    public void printAvailableCompressors() {
        StringBuilder builder = new StringBuilder();
        builder.append("Available compressors: ");
        for (String comp : this.codecs.keySet()) {
            builder.append("[").append(comp).append("] ");
        }
        System.out.println(builder.toString());
    }

    public static BasicNDArrayCompressor getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicNDArrayCompressor setDefaultCompression(@NonNull String algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm");
        }
        algorithm = algorithm.toUpperCase();
        BasicNDArrayCompressor basicNDArrayCompressor = this;
        synchronized (basicNDArrayCompressor) {
            this.defaultCompression = algorithm;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultCompression() {
        BasicNDArrayCompressor basicNDArrayCompressor = this;
        synchronized (basicNDArrayCompressor) {
            return this.defaultCompression;
        }
    }

    public DataBuffer compress(DataBuffer buffer) {
        return this.compress(buffer, this.getDefaultCompression());
    }

    public DataBuffer compress(DataBuffer buffer, String algorithm) {
        if (!this.codecs.containsKey(algorithm = algorithm.toUpperCase())) {
            throw new RuntimeException("Non-existent compression algorithm requested: [" + algorithm + "]");
        }
        return this.codecs.get(algorithm).compress(buffer);
    }

    public INDArray compress(INDArray array) {
        return this.compress(array, this.getDefaultCompression());
    }

    public void compressi(INDArray array) {
        this.compressi(array, this.getDefaultCompression());
    }

    public INDArray compress(INDArray array, String algorithm) {
        if (!this.codecs.containsKey(algorithm = algorithm.toUpperCase())) {
            throw new RuntimeException("Non-existent compression algorithm requested: [" + algorithm + "]");
        }
        return this.codecs.get(algorithm).compress(array);
    }

    public void compressi(INDArray array, String algorithm) {
        if (!this.codecs.containsKey(algorithm = algorithm.toUpperCase())) {
            throw new RuntimeException("Non-existent compression algorithm requested: [" + algorithm + "]");
        }
        this.codecs.get(algorithm).compressi(array);
    }

    public DataBuffer decompress(DataBuffer buffer) {
        if (buffer.dataType() != DataBuffer.Type.COMPRESSED) {
            throw new IllegalStateException("You can't decompress DataBuffer with dataType of: " + buffer.dataType());
        }
        CompressedDataBuffer comp = (CompressedDataBuffer)buffer;
        CompressionDescriptor descriptor = comp.getCompressionDescriptor();
        if (!this.codecs.containsKey(descriptor.getCompressionAlgorithm())) {
            throw new RuntimeException("Non-existent compression algorithm requested: [" + descriptor.getCompressionAlgorithm() + "]");
        }
        return this.codecs.get(descriptor.getCompressionAlgorithm()).decompress(buffer);
    }

    public INDArray decompress(INDArray array) {
        if (array.data().dataType() != DataBuffer.Type.COMPRESSED) {
            return array;
        }
        CompressedDataBuffer comp = (CompressedDataBuffer)array.data();
        CompressionDescriptor descriptor = comp.getCompressionDescriptor();
        if (!this.codecs.containsKey(descriptor.getCompressionAlgorithm())) {
            throw new RuntimeException("Non-existent compression algorithm requested: [" + descriptor.getCompressionAlgorithm() + "]");
        }
        return this.codecs.get(descriptor.getCompressionAlgorithm()).decompress(array);
    }

    public void decompressi(INDArray array) {
        if (array.data().dataType() != DataBuffer.Type.COMPRESSED) {
            return;
        }
        CompressedDataBuffer comp = (CompressedDataBuffer)array.data();
        CompressionDescriptor descriptor = comp.getCompressionDescriptor();
        if (!this.codecs.containsKey(descriptor.getCompressionAlgorithm())) {
            throw new RuntimeException("Non-existent compression algorithm requested: [" + descriptor.getCompressionAlgorithm() + "]");
        }
        this.codecs.get(descriptor.getCompressionAlgorithm()).decompressi(array);
    }

    public void autoDecompress(INDArray ... arrays) {
        for (INDArray array : arrays) {
            this.autoDecompress(array);
        }
    }

    public void autoDecompress(INDArray array) {
        if (array.isCompressed()) {
            this.decompressi(array);
        }
    }
}

