/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class DropOut
extends BaseTransformOp {
    private double p;

    public DropOut() {
    }

    public DropOut(INDArray x, double p) {
        super(x);
        this.p = p;
        this.init(x, null, x, x.length());
    }

    public DropOut(INDArray x, INDArray z, double p) {
        super(x, z);
        this.p = p;
        this.init(x, null, z, x.length());
    }

    public DropOut(INDArray x, INDArray z, double p, long n) {
        super(x, z, n);
        this.p = p;
        this.init(x, null, z, n);
    }

    @Override
    public int opNum() {
        return 43;
    }

    @Override
    public String name() {
        return "dropout";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new DropOut(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.p, (long)xAlongDimension.length());
        }
        return new DropOut(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.p, (long)xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new DropOut(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.p, (long)xAlongDimension.length());
        }
        return new DropOut(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.p, (long)xAlongDimension.length());
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.p, (double)n};
    }
}

