/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;

public class LinAlgExceptions {
    public static void assertSameLength(INDArray n, INDArray n2) {
        if (n.length() != n2.length()) {
            throw new IllegalStateException("Mis matched lengths: [" + n.length() + "] != [" + n2.length() + "]");
        }
    }

    public static void assertSameShape(INDArray n, INDArray n2) {
        if (!Arrays.equals(n.shape(), n2.shape())) {
            throw new IllegalStateException("Mis matched shapes");
        }
    }

    public static void assertRows(INDArray n, INDArray n2) {
        if (n.rows() != n2.rows()) {
            throw new IllegalStateException("Mis matched rows");
        }
    }

    public static void assertVector(INDArray ... arr) {
        for (INDArray a1 : arr) {
            LinAlgExceptions.assertVector(a1);
        }
    }

    public static void assertMatrix(INDArray ... arr) {
        for (INDArray a1 : arr) {
            LinAlgExceptions.assertMatrix(a1);
        }
    }

    public static void assertVector(INDArray arr) {
        if (!arr.isVector()) {
            throw new IllegalArgumentException("Array must be a vector");
        }
    }

    public static void assertMatrix(INDArray arr) {
        if (arr.shape().length > 2) {
            throw new IllegalArgumentException("Array must be a matrix");
        }
    }

    public static void assertMultiplies(INDArray nd1, INDArray nd2) {
        if (nd1.columns() == nd2.rows() || nd1.rows() == nd2.columns()) {
            return;
        }
        throw new IllegalStateException("Column of left array " + nd1.columns() + " != rows of right " + nd2.rows() + " or rows of left array " + nd1.rows() + " != columns of right " + nd2.columns());
    }

    public static void assertColumns(INDArray n, INDArray n2) {
        if (n.columns() != n2.columns()) {
            throw new IllegalStateException("Mis matched rows");
        }
    }

    public static void assertValidNum(INDArray n) {
        INDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            double d = linear.getDouble(i);
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            throw new IllegalStateException("Found infinite or nan");
        }
    }
}

