/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import java.io.File;
import java.io.IOException;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.preprocessor.DataNormalization;
import org.nd4j.linalg.dataset.api.preprocessor.NormalizerMinMaxScaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePreProcessingScaler
implements DataNormalization {
    private static Logger logger = LoggerFactory.getLogger(NormalizerMinMaxScaler.class);
    private double minRange;
    private double maxRange;
    private double maxPixelVal;
    private int maxBits;

    public ImagePreProcessingScaler() {
        this(0.0, 1.0, 8);
    }

    public ImagePreProcessingScaler(double a, double b) {
        this(a, b, 8);
    }

    public ImagePreProcessingScaler(double a, double b, int maxBits) {
        this.maxPixelVal = Math.pow(2.0, maxBits) - 1.0;
        this.minRange = a;
        this.maxRange = b;
    }

    @Override
    public void fit(DataSet dataSet) {
    }

    @Override
    public void fit(DataSetIterator iterator) {
    }

    @Override
    public void preProcess(DataSet toPreProcess) {
        toPreProcess.getFeatureMatrix().divi(this.maxPixelVal);
        if (this.maxRange - this.minRange != 1.0) {
            toPreProcess.getFeatureMatrix().muli(this.maxRange - this.minRange);
        }
        if (this.minRange != 0.0) {
            toPreProcess.getFeatureMatrix().addi(this.minRange);
        }
    }

    @Override
    public void transform(DataSet toPreProcess) {
        this.preProcess(toPreProcess);
    }

    @Override
    public void load(File ... statistics) throws IOException {
    }

    @Override
    public void save(File ... statistics) throws IOException {
    }
}

