/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ExistingMiniBatchDataSetIterator
implements DataSetIterator {
    private List<String[]> paths;
    private int currIdx;
    private File rootDir;
    private int totalBatches = -1;
    private DataSetPreProcessor dataSetPreProcessor;

    public ExistingMiniBatchDataSetIterator(File rootDir) {
        this.rootDir = rootDir;
        this.paths = new ArrayList<String[]>();
        if (this.totalBatches < 1) {
            this.totalBatches = rootDir.list().length;
        }
    }

    @Override
    public DataSet next(int num) {
        throw new UnsupportedOperationException("Unable to load custom number of examples");
    }

    @Override
    public int totalExamples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int inputColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int totalOutcomes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public void reset() {
        this.currIdx = 0;
    }

    @Override
    public int batch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int cursor() {
        return this.currIdx;
    }

    @Override
    public int numExamples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.dataSetPreProcessor = preProcessor;
    }

    @Override
    public DataSetPreProcessor getPreProcessor() {
        return this.dataSetPreProcessor;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currIdx < this.totalBatches;
    }

    @Override
    public void remove() {
    }

    @Override
    public DataSet next() {
        try {
            DataSet ret = this.read(this.currIdx);
            if (this.dataSetPreProcessor != null) {
                this.dataSetPreProcessor.preProcess(ret);
            }
            ++this.currIdx;
            return ret;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read dataset");
        }
    }

    private DataSet read(int idx) throws IOException {
        File path = new File(this.rootDir, String.format("dataset-%d.bin", idx));
        DataSet d = new DataSet();
        d.load(path);
        return d;
    }
}

