/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class ACos
extends BaseTransformOp {
    public ACos() {
    }

    public ACos(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public ACos(INDArray x) {
        super(x);
    }

    public ACos(INDArray x, INDArray y) {
        super(x, y);
    }

    public ACos(INDArray indArray, INDArray indArray1, int length) {
        super(indArray, indArray1, length);
    }

    @Override
    public int opNum() {
        return 16;
    }

    @Override
    public String name() {
        return "acos";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.acos(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.acos(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.acos(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.acos((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.acos((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.acos((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.acos((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.acos(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ACos(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ACos(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ACos(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ACos(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

