/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Min
extends BaseTransformOp {
    public Min() {
    }

    public Min(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Min(INDArray x) {
        super(x);
    }

    public Min(INDArray x, INDArray z) {
        super(x, z);
    }

    public Min(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    @Override
    public int opNum() {
        return 14;
    }

    @Override
    public String name() {
        return "min";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        double val = origin.absoluteValue().doubleValue();
        return val < other ? origin : Nd4j.createComplexNumber(other, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        float val = origin.absoluteValue().floatValue();
        return val < other ? origin : Nd4j.createComplexNumber(Float.valueOf(other), 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.absoluteValue().doubleValue() < other.absoluteValue().doubleValue() ? origin : other;
    }

    @Override
    public float op(float origin, float other) {
        return FastMath.min((float)origin, (float)other);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.min((double)origin, (double)other);
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Min(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Min(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Min(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Min(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

