/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.Step;
import org.nd4j.linalg.factory.Nd4j;

public class RectifedLinear
extends BaseTransformOp {
    private double cutoff = 0.0;

    public RectifedLinear() {
    }

    public RectifedLinear(INDArray x, INDArray z, double cutoff) {
        super(x, z);
        this.cutoff = cutoff;
    }

    public RectifedLinear(INDArray x, INDArray z, long n, double cutoff) {
        super(x, z, n);
        this.cutoff = cutoff;
    }

    public RectifedLinear(INDArray x, INDArray y, INDArray z, long n, double cutoff) {
        super(x, y, z, n);
        this.cutoff = cutoff;
    }

    public RectifedLinear(INDArray x, double cutoff) {
        super(x);
        this.cutoff = cutoff;
    }

    public RectifedLinear(INDArray x, INDArray z) {
        super(x, z);
    }

    public RectifedLinear(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public RectifedLinear(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public RectifedLinear(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    public RectifedLinear(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 33;
    }

    @Override
    public String name() {
        return "relu";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin.realComponent().doubleValue() < this.cutoff ? Nd4j.createComplexNumber(this.cutoff, 0) : origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin.realComponent().doubleValue() < this.cutoff ? Nd4j.createComplexNumber(this.cutoff, 0) : origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.realComponent().doubleValue() < this.cutoff ? Nd4j.createComplexNumber(this.cutoff, 0) : origin;
    }

    @Override
    public float op(float origin, float other) {
        return (double)origin < this.cutoff ? (float)this.cutoff : origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin < this.cutoff ? this.cutoff : origin;
    }

    @Override
    public double op(double origin) {
        return origin < this.cutoff ? this.cutoff : origin;
    }

    @Override
    public float op(float origin) {
        return (double)origin < this.cutoff ? (float)this.cutoff : origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin.realComponent().doubleValue() < this.cutoff ? Nd4j.createComplexNumber(this.cutoff, 0) : origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new RectifedLinear(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
        }
        return new RectifedLinear(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new RectifedLinear(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
        }
        return new RectifedLinear(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.cutoff);
    }

    @Override
    public TransformOp derivative() {
        return new Step(this.x, this.y, this.z, this.n, this.cutoff);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.cutoff};
    }
}

