/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Max
extends BaseAccumulation {
    public Max() {
    }

    public Max(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Max(INDArray x) {
        super(x);
    }

    public Max(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public double op(double origin, double other) {
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin;
    }

    @Override
    public double update(double accum, double x) {
        return FastMath.max((double)accum, (double)x);
    }

    @Override
    public double update(double accum, double x, double y) {
        return FastMath.max((double)accum, (double)x);
    }

    @Override
    public float update(float accum, float x) {
        return FastMath.max((float)accum, (float)x);
    }

    @Override
    public float update(float accum, float x, float y) {
        return FastMath.max((float)accum, (float)x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.absoluteValue().doubleValue() > x ? accum : Nd4j.createComplexNumber(x, 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.absoluteValue().doubleValue() > x ? accum : Nd4j.createComplexNumber(x, 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.absoluteValue().doubleValue() > x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.absoluteValue().doubleValue() > x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.absoluteValue().doubleValue() > x.absoluteValue().doubleValue() ? accum : x;
    }

    @Override
    public int opNum() {
        return 3;
    }

    @Override
    public String name() {
        return "max";
    }

    @Override
    public double zeroDouble() {
        return -1.7976931348623157E308;
    }

    @Override
    public float zeroFloat() {
        return -3.4028235E38f;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Max(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Max(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Max(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Max(this.x.tensorAlongDimension(index, dimension));
    }
}

