/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.nio.Buffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseOp
implements Op {
    protected INDArray x;
    protected INDArray y;
    protected INDArray z;
    protected long n;
    protected long numProcessed;
    protected Object[] extraArgs;
    protected boolean passThrough;

    public BaseOp() {
    }

    @Override
    public boolean isExecSpecial() {
        return false;
    }

    @Override
    public DataBuffer extraArgsDataBuff() {
        if (this.extraArgs != null) {
            if (this.x.data().dataType() == DataBuffer.Type.FLOAT) {
                float[] extraz = new float[this.extraArgs.length];
                for (int i = 0; i < this.extraArgs.length; ++i) {
                    float val;
                    Number arg = (Number)this.extraArgs[i];
                    extraz[i] = val = arg.floatValue();
                }
                return Nd4j.getConstantHandler().getConstantBuffer(extraz);
            }
            double[] extraz = new double[this.extraArgs.length];
            for (int i = 0; i < this.extraArgs.length; ++i) {
                double val;
                Number arg = (Number)this.extraArgs[i];
                extraz[i] = val = arg.doubleValue();
            }
            return Nd4j.getConstantHandler().getConstantBuffer(extraz);
        }
        return null;
    }

    @Override
    public Buffer extraArgsBuff() {
        if (this.extraArgs != null) {
            if (this.x.data().dataType() == DataBuffer.Type.FLOAT) {
                DataBuffer retBuff = Nd4j.createBuffer(new float[this.extraArgs.length]);
                for (int i = 0; i < this.extraArgs.length; ++i) {
                    Number val = (Number)this.extraArgs[i];
                    retBuff.put((long)i, val.floatValue());
                }
                return retBuff.asNioFloat();
            }
            DataBuffer retBuff = Nd4j.createBuffer(new double[this.extraArgs.length]);
            for (int i = 0; i < this.extraArgs.length; ++i) {
                Number val = (Number)this.extraArgs[i];
                retBuff.put((long)i, val.doubleValue());
            }
            return retBuff.asNioDouble();
        }
        return null;
    }

    @Override
    public boolean isPassThrough() {
        return this.passThrough;
    }

    @Override
    public void setX(INDArray x) {
        if (x == null) {
            throw new IllegalArgumentException("X must not be null");
        }
        this.x = x;
        this.numProcessed = 0L;
    }

    @Override
    public void setZ(INDArray z) {
        if (z == null) {
            throw new IllegalArgumentException("Z must not be null");
        }
        this.z = z;
        this.numProcessed = 0L;
    }

    @Override
    public void setY(INDArray y) {
        if (y == null) {
            throw new IllegalArgumentException("Y must not be null");
        }
        this.y = y;
        this.numProcessed = 0L;
    }

    public BaseOp(INDArray x, INDArray z) {
        this(x, z, x.lengthLong());
    }

    public BaseOp(INDArray x, INDArray z, long n) {
        this(x, null, z, n);
    }

    public BaseOp(INDArray x, INDArray y, INDArray z, long n) {
        this.n = n;
        this.init(x, y, z, n);
    }

    public BaseOp(INDArray x) {
        this(x, null, x, x.lengthLong());
    }

    @Override
    public Object[] extraArgs() {
        return this.extraArgs;
    }

    @Override
    public INDArray x() {
        return this.x;
    }

    @Override
    public INDArray y() {
        return this.y;
    }

    @Override
    public INDArray z() {
        return this.z;
    }

    @Override
    public long n() {
        return this.n;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.n = n;
    }

    @Override
    public void setN(long n) {
        this.n = n;
    }

    @Override
    public long numProcessed() {
        return this.numProcessed;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public void exec() {
    }

    @Override
    public void exec(int ... dimensions) {
    }
}

