/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.impl.BaseLevel;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseLevel1
extends BaseLevel
implements Level1 {
    @Override
    public double dot(int n, double alpha, INDArray X, INDArray Y) {
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            return this.ddot(n, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(X));
        }
        return this.sdot(n, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(X));
    }

    @Override
    public double dot(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                return this.sdot(n, x, offsetX, incrX, y, offsetY, incrY);
            }
            return this.ddot(n, x, offsetX, incrX, y, offsetY, incrY);
        }
        int[] shapex = new int[]{1, n};
        int[] shapey = new int[]{1, n};
        int[] stridex = new int[]{incrX, incrX};
        int[] stridey = new int[]{incrY, incrY};
        INDArray arrX = Nd4j.create(x, shapex, stridex, offsetX, 'c');
        INDArray arrY = Nd4j.create(x, shapey, stridey, offsetY, 'c');
        return this.dot(n, 0.0, arrX, arrY);
    }

    @Override
    public IComplexNumber dot(int n, IComplexNumber alpha, IComplexNDArray X, IComplexNDArray Y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double nrm2(INDArray arr) {
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            return this.dnrm2(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        return this.snrm2(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
    }

    @Override
    public IComplexNumber nrm2(IComplexNDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asum(INDArray arr) {
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            return this.dasum(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        return this.sasum(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
    }

    @Override
    public double asum(int n, DataBuffer x, int offsetX, int incrX) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                return this.sasum(n, x, offsetX, incrX);
            }
            return this.dasum(n, x, offsetX, incrX);
        }
        int[] shapex = new int[]{1, n};
        int[] stridex = new int[]{incrX, incrX};
        INDArray arrX = Nd4j.create(x, shapex, stridex, offsetX, 'c');
        return this.asum(arrX);
    }

    @Override
    public IComplexNumber asum(IComplexNDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(int n, INDArray arr, int stride) {
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            return this.idamax(n, arr, stride);
        }
        return this.isamax(n, arr, stride);
    }

    @Override
    public int iamax(int n, DataBuffer x, int offsetX, int incrX) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                return this.isamax(n, x, offsetX, incrX);
            }
            return this.isamax(n, x, offsetX, incrX);
        }
        int[] shapex = new int[]{1, n};
        int[] stridex = new int[]{incrX, incrX};
        INDArray arrX = Nd4j.create(x, shapex, stridex, offsetX, 'c');
        return this.iamax(n, arrX, incrX);
    }

    @Override
    public int iamax(INDArray arr) {
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            return this.idamax(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        return this.isamax(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
    }

    @Override
    public int iamax(IComplexNDArray arr) {
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            return this.izamax(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        return this.icamax(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
    }

    @Override
    public int iamin(INDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamin(IComplexNDArray arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void swap(INDArray x, INDArray y) {
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dswap(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            this.sswap(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void swap(IComplexNDArray x, IComplexNDArray y) {
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zswap(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            this.cswap(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void copy(INDArray x, INDArray y) {
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dcopy(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            this.scopy(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void copy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.DOUBLE) {
                this.dcopy(n, x, offsetX, incrX, y, offsetY, incrY);
            } else {
                this.scopy(n, x, offsetX, incrX, y, offsetY, incrY);
            }
        } else {
            int[] shapex = new int[]{1, n};
            int[] shapey = new int[]{1, n};
            int[] stridex = new int[]{incrX, incrX};
            int[] stridey = new int[]{incrY, incrY};
            INDArray arrX = Nd4j.create(x, shapex, stridex, offsetX, 'c');
            INDArray arrY = Nd4j.create(x, shapey, stridey, offsetY, 'c');
            this.copy(arrX, arrY);
        }
    }

    @Override
    public void copy(IComplexNDArray x, IComplexNDArray y) {
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zcopy(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            this.ccopy(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void axpy(int n, double alpha, INDArray x, INDArray y) {
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.daxpy(n, alpha, x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            this.saxpy(n, (float)alpha, x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void axpy(int n, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.DOUBLE) {
                this.daxpy(n, alpha, x, offsetX, incrX, y, offsetY, incrY);
            } else {
                this.saxpy(n, (float)alpha, x, offsetX, incrX, y, offsetY, incrY);
            }
        } else {
            int[] shapex = new int[]{1, n};
            int[] shapey = new int[]{1, n};
            int[] stridex = new int[]{incrX, incrX};
            int[] stridey = new int[]{incrY, incrY};
            INDArray arrX = Nd4j.create(x, shapex, stridex, offsetX, 'c');
            INDArray arrY = Nd4j.create(x, shapey, stridey, offsetY, 'c');
            this.axpy(n, alpha, arrX, arrY);
        }
    }

    @Override
    public void axpy(int n, IComplexNumber alpha, IComplexNDArray x, IComplexNDArray y) {
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zaxpy(n, alpha.asDouble(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            this.caxpy(n, alpha.asFloat(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void rotg(INDArray a, INDArray b, INDArray c, INDArray s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rot(int N, INDArray X, INDArray Y, double c, double s) {
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.drot(N, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(X), c, s);
        } else {
            this.srot(N, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(X), (float)c, (float)s);
        }
    }

    @Override
    public void rot(int N, IComplexNDArray X, IComplexNDArray Y, IComplexNumber c, IComplexNumber s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotmg(INDArray d1, INDArray d2, INDArray b1, double b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotmg(IComplexNDArray d1, IComplexNDArray d2, IComplexNDArray b1, IComplexNumber b2, IComplexNDArray P) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scal(int N, double alpha, INDArray X) {
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dscal(N, alpha, X, BlasBufferUtil.getBlasStride(X));
        } else {
            this.sscal(N, (float)alpha, X, BlasBufferUtil.getBlasStride(X));
        }
    }

    @Override
    public void scal(int N, IComplexNumber alpha, IComplexNDArray X) {
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zscal(N, alpha.asDouble(), X, BlasBufferUtil.getBlasStride(X));
        } else {
            this.cscal(N, alpha.asFloat(), X, BlasBufferUtil.getBlasStride(X));
        }
    }

    protected abstract float sdsdot(int var1, float var2, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract double dsdot(int var1, INDArray var2, int var3, INDArray var4, int var5);

    protected abstract float sdot(int var1, INDArray var2, int var3, INDArray var4, int var5);

    protected abstract float sdot(int var1, DataBuffer var2, int var3, int var4, DataBuffer var5, int var6, int var7);

    protected abstract double ddot(int var1, INDArray var2, int var3, INDArray var4, int var5);

    protected abstract double ddot(int var1, DataBuffer var2, int var3, int var4, DataBuffer var5, int var6, int var7);

    protected abstract void cdotu_sub(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5, IComplexNDArray var6);

    protected abstract void cdotc_sub(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5, IComplexNDArray var6);

    protected abstract void zdotu_sub(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5, IComplexNDArray var6);

    protected abstract void zdotc_sub(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5, IComplexNDArray var6);

    protected abstract float snrm2(int var1, INDArray var2, int var3);

    protected abstract float sasum(int var1, INDArray var2, int var3);

    protected abstract float sasum(int var1, DataBuffer var2, int var3, int var4);

    protected abstract double dnrm2(int var1, INDArray var2, int var3);

    protected abstract double dasum(int var1, INDArray var2, int var3);

    protected abstract double dasum(int var1, DataBuffer var2, int var3, int var4);

    protected abstract float scnrm2(int var1, IComplexNDArray var2, int var3);

    protected abstract float scasum(int var1, IComplexNDArray var2, int var3);

    protected abstract double dznrm2(int var1, IComplexNDArray var2, int var3);

    protected abstract double dzasum(int var1, IComplexNDArray var2, int var3);

    protected abstract int isamax(int var1, INDArray var2, int var3);

    protected abstract int isamax(int var1, DataBuffer var2, int var3, int var4);

    protected abstract int idamax(int var1, INDArray var2, int var3);

    protected abstract int idamax(int var1, DataBuffer var2, int var3, int var4);

    protected abstract int icamax(int var1, IComplexNDArray var2, int var3);

    protected abstract int izamax(int var1, IComplexNDArray var2, int var3);

    protected abstract void sswap(int var1, INDArray var2, int var3, INDArray var4, int var5);

    protected abstract void scopy(int var1, INDArray var2, int var3, INDArray var4, int var5);

    protected abstract void scopy(int var1, DataBuffer var2, int var3, int var4, DataBuffer var5, int var6, int var7);

    protected abstract void saxpy(int var1, float var2, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract void saxpy(int var1, float var2, DataBuffer var3, int var4, int var5, DataBuffer var6, int var7, int var8);

    protected abstract void dswap(int var1, INDArray var2, int var3, INDArray var4, int var5);

    protected abstract void dcopy(int var1, INDArray var2, int var3, INDArray var4, int var5);

    protected abstract void dcopy(int var1, DataBuffer var2, int var3, int var4, DataBuffer var5, int var6, int var7);

    protected abstract void daxpy(int var1, double var2, INDArray var4, int var5, INDArray var6, int var7);

    protected abstract void daxpy(int var1, double var2, DataBuffer var4, int var5, int var6, DataBuffer var7, int var8, int var9);

    protected abstract void cswap(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5);

    protected abstract void ccopy(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5);

    protected abstract void caxpy(int var1, IComplexFloat var2, IComplexNDArray var3, int var4, IComplexNDArray var5, int var6);

    protected abstract void zswap(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5);

    protected abstract void zcopy(int var1, IComplexNDArray var2, int var3, IComplexNDArray var4, int var5);

    protected abstract void zaxpy(int var1, IComplexDouble var2, IComplexNDArray var3, int var4, IComplexNDArray var5, int var6);

    protected abstract void srotg(float var1, float var2, float var3, float var4);

    protected abstract void srotmg(float var1, float var2, float var3, float var4, INDArray var5);

    protected abstract void srot(int var1, INDArray var2, int var3, INDArray var4, int var5, float var6, float var7);

    protected abstract void srotm(int var1, INDArray var2, int var3, INDArray var4, int var5, INDArray var6);

    protected abstract void drotg(double var1, double var3, double var5, double var7);

    protected abstract void drotmg(double var1, double var3, double var5, double var7, INDArray var9);

    protected abstract void drot(int var1, INDArray var2, int var3, INDArray var4, int var5, double var6, double var8);

    protected abstract void drotm(int var1, INDArray var2, int var3, INDArray var4, int var5, INDArray var6);

    protected abstract void sscal(int var1, float var2, INDArray var3, int var4);

    protected abstract void dscal(int var1, double var2, INDArray var4, int var5);

    protected abstract void cscal(int var1, IComplexFloat var2, IComplexNDArray var3, int var4);

    protected abstract void zscal(int var1, IComplexDouble var2, IComplexNDArray var3, int var4);

    protected abstract void csscal(int var1, float var2, IComplexNDArray var3, int var4);

    protected abstract void zdscal(int var1, double var2, IComplexNDArray var4, int var5);

    @Override
    public boolean supportsDataBufferL1Ops() {
        return true;
    }
}

