/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.BaseElementWiseOp;

public class Max
extends BaseElementWiseOp {
    private Number max = 0;

    public Max(Float max) {
        this.max = max;
    }

    public Max(Number max) {
        this.max = max;
    }

    public Max() {
    }

    public Object apply(INDArray from, Object value, int i) {
        if (value instanceof IComplexNumber) {
            IComplexNumber num = (IComplexNumber)value;
            if (num.realComponent().doubleValue() > this.max.doubleValue()) {
                return num;
            }
            return num.set(this.max, num.imaginaryComponent());
        }
        float val = ((Float)value).floatValue();
        return Float.valueOf((float)Math.max(this.max.doubleValue(), (double)val));
    }
}

