/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class Indices {
    public static int[] offsets(NDArrayIndex ... indices) {
        int[] ret = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            int offset = indices[i].offset();
            ret[i] = offset == 0 && i > 0 && i < indices.length - 1 ? 1 : indices[i].offset();
        }
        return ret;
    }

    public static NDArrayIndex[] fillIn(int[] shape, NDArrayIndex ... indexes) {
        if (shape.length == indexes.length) {
            return indexes;
        }
        NDArrayIndex[] newIndexes = new NDArrayIndex[shape.length];
        System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
        for (int i = indexes.length; i < shape.length; ++i) {
            newIndexes[i] = NDArrayIndex.interval(0, shape[i]);
        }
        return newIndexes;
    }

    public static NDArrayIndex[] adjustIndices(int[] originalShape, NDArrayIndex ... indexes) {
        if (indexes.length < originalShape.length) {
            indexes = Indices.fillIn(originalShape, indexes);
        }
        if (indexes.length > originalShape.length) {
            NDArrayIndex[] ret = new NDArrayIndex[originalShape.length];
            System.arraycopy(indexes, 0, ret, 0, originalShape.length);
            return ret;
        }
        if (indexes.length == originalShape.length) {
            return indexes;
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i].end() < originalShape[i]) continue;
            indexes[i] = NDArrayIndex.interval(0, originalShape[i] - 1);
        }
        return indexes;
    }

    public static int[] strides(char ordering, NDArrayIndex ... indexes) {
        return Nd4j.getStrides(Indices.shape(indexes), ordering);
    }

    public static int[] shape(NDArrayIndex ... indices) {
        int[] ret = new int[indices.length];
        for (int i = 0; i < ret.length; ++i) {
            int[] currIndices = indices[i].indices();
            int end = currIndices[currIndices.length - 1] + 1;
            int begin = currIndices[0];
            ret[i] = Math.abs(end - begin);
        }
        return ret;
    }

    public static int[] shape(int[] shape, NDArrayIndex ... indices) {
        if (indices.length > shape.length) {
            return shape;
        }
        int[] ret = new int[indices.length];
        for (int i = 0; i < ret.length; ++i) {
            int[] currIndices = indices[i].indices();
            int end = currIndices[currIndices.length - 1] + 1;
            if (end > shape[i]) {
                end = shape[i] - 1;
            }
            int begin = currIndices[0];
            ret[i] = Math.abs(end - begin);
        }
        return ret;
    }
}

