/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.ExplicitTableAliasCalculator;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.DefaultUpdateStatementProvider;
import org.mybatis.dynamic.sql.update.render.SetPhraseVisitor;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.Messages;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class UpdateRenderer {
    private final UpdateModel updateModel;
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence = new AtomicInteger(1);
    private final TableAliasCalculator tableAliasCalculator;

    private UpdateRenderer(Builder builder) {
        this.updateModel = Objects.requireNonNull(builder.updateModel);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.tableAliasCalculator = builder.updateModel.tableAlias().map(a -> ExplicitTableAliasCalculator.of(this.updateModel.table(), a)).orElseGet(TableAliasCalculator::empty);
    }

    public UpdateStatementProvider render() {
        SetPhraseVisitor visitor = new SetPhraseVisitor(this.sequence, this.renderingStrategy, this.tableAliasCalculator);
        List fragmentsAndParameters = this.updateModel.mapColumnMappings(m -> m.accept(visitor)).collect(Collectors.toList());
        if (fragmentsAndParameters.stream().noneMatch(Optional::isPresent)) {
            throw new InvalidSqlException(Messages.getString("ERROR.18"));
        }
        return this.updateModel.whereModel().flatMap(this::renderWhereClause).map(wc -> this.renderWithWhereClause(fragmentsAndParameters, (WhereClauseProvider)wc)).orElseGet(() -> this.renderWithoutWhereClause(fragmentsAndParameters));
    }

    private UpdateStatementProvider renderWithWhereClause(List<Optional<FragmentAndParameters>> fragmentsAndParameters, WhereClauseProvider whereClause) {
        return DefaultUpdateStatementProvider.withUpdateStatement(this.calculateUpdateStatement(fragmentsAndParameters, whereClause)).withParameters(this.calculateParameters(fragmentsAndParameters)).withParameters(whereClause.getParameters()).build();
    }

    private String calculateUpdateStatement(List<Optional<FragmentAndParameters>> fragmentsAndParameters, WhereClauseProvider whereClause) {
        return this.calculateUpdateStatement(fragmentsAndParameters) + StringUtilities.spaceBefore(whereClause.getWhereClause());
    }

    private String calculateUpdateStatement(List<Optional<FragmentAndParameters>> fragmentsAndParameters) {
        SqlTable table = this.updateModel.table();
        String tableName = table.tableNameAtRuntime();
        String aliasedTableName = this.tableAliasCalculator.aliasForTable(table).map(a -> tableName + " " + a).orElse(tableName);
        return "update" + StringUtilities.spaceBefore(aliasedTableName) + StringUtilities.spaceBefore(this.calculateSetPhrase(fragmentsAndParameters));
    }

    private UpdateStatementProvider renderWithoutWhereClause(List<Optional<FragmentAndParameters>> fragmentsAndParameters) {
        return DefaultUpdateStatementProvider.withUpdateStatement(this.calculateUpdateStatement(fragmentsAndParameters)).withParameters(this.calculateParameters(fragmentsAndParameters)).build();
    }

    private String calculateSetPhrase(List<Optional<FragmentAndParameters>> fragmentsAndParameters) {
        return fragmentsAndParameters.stream().filter(Optional::isPresent).map(Optional::get).map(FragmentAndParameters::fragment).collect(Collectors.joining(", ", "set ", ""));
    }

    private Map<String, Object> calculateParameters(List<Optional<FragmentAndParameters>> fragmentsAndParameters) {
        return fragmentsAndParameters.stream().filter(Optional::isPresent).map(Optional::get).map(FragmentAndParameters::parameters).collect(HashMap::new, HashMap::putAll, HashMap::putAll);
    }

    private Optional<WhereClauseProvider> renderWhereClause(WhereModel whereModel) {
        return WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).withTableAliasCalculator(this.tableAliasCalculator).build().render();
    }

    public static Builder withUpdateModel(UpdateModel updateModel) {
        return new Builder().withUpdateModel(updateModel);
    }

    public static class Builder {
        private UpdateModel updateModel;
        private RenderingStrategy renderingStrategy;

        public Builder withUpdateModel(UpdateModel updateModel) {
            this.updateModel = updateModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public UpdateRenderer build() {
            return new UpdateRenderer(this);
        }
    }
}

