/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.VisitableCondition;

public abstract class AbstractListValueCondition<T>
implements VisitableCondition<T> {
    protected final Collection<T> values;
    protected final Callback emptyCallback;

    protected AbstractListValueCondition(Collection<T> values) {
        this(values, () -> {});
    }

    protected AbstractListValueCondition(Collection<T> values, Callback emptyCallback) {
        this.values = Objects.requireNonNull(values);
        this.emptyCallback = Objects.requireNonNull(emptyCallback);
    }

    public final <R> Stream<R> mapValues(Function<T, R> mapper) {
        return this.values.stream().map(mapper);
    }

    @Override
    public boolean shouldRender() {
        return !this.values.isEmpty();
    }

    @Override
    public void renderingSkipped() {
        this.emptyCallback.call();
    }

    @Override
    public <R> R accept(ConditionVisitor<T, R> visitor) {
        return visitor.visit(this);
    }

    private <R> Collection<R> applyMapper(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return this.values.stream().map(mapper).collect(Collectors.toList());
    }

    private Collection<T> applyFilter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.values.stream().filter(predicate).collect(Collectors.toList());
    }

    protected <S extends AbstractListValueCondition<T>> S filterSupport(Predicate<? super T> predicate, BiFunction<Collection<T>, Callback, S> constructor, S self, Supplier<S> emptySupplier) {
        if (this.shouldRender()) {
            Collection<T> filtered = this.applyFilter(predicate);
            return (S)(filtered.isEmpty() ? (AbstractListValueCondition)emptySupplier.get() : (AbstractListValueCondition)constructor.apply(filtered, this.emptyCallback));
        }
        return self;
    }

    protected <R, S extends AbstractListValueCondition<R>> S mapSupport(Function<? super T, ? extends R> mapper, BiFunction<Collection<R>, Callback, S> constructor, Supplier<S> emptySupplier) {
        if (this.shouldRender()) {
            return (S)((AbstractListValueCondition)constructor.apply(this.applyMapper(mapper), this.emptyCallback));
        }
        return (S)((AbstractListValueCondition)emptySupplier.get());
    }

    public abstract AbstractListValueCondition<T> filter(Predicate<? super T> var1);

    public abstract AbstractListValueCondition<T> withListEmptyCallback(Callback var1);

    public abstract String renderCondition(String var1, Stream<String> var2);
}

