/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.ColumnAndConditionCriterion;
import org.mybatis.dynamic.sql.ExistsCriterion;
import org.mybatis.dynamic.sql.ExistsPredicate;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.SqlCriterionVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.where.render.RenderedCriterion;
import org.mybatis.dynamic.sql.where.render.WhereConditionVisitor;

public class CriterionRenderer
implements SqlCriterionVisitor<Optional<RenderedCriterion>> {
    private final AtomicInteger sequence;
    private final RenderingStrategy renderingStrategy;
    private final TableAliasCalculator tableAliasCalculator;
    private final String parameterName;

    private CriterionRenderer(Builder builder) {
        this.sequence = Objects.requireNonNull(builder.sequence);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.tableAliasCalculator = Objects.requireNonNull(builder.tableAliasCalculator);
        this.parameterName = builder.parameterName;
    }

    @Override
    public <T> Optional<RenderedCriterion> visit(ColumnAndConditionCriterion<T> criterion) {
        if (criterion.condition().shouldRender()) {
            return this.renderWithInitialCondition(this.renderCondition(criterion), criterion);
        }
        criterion.condition().renderingSkipped();
        return this.renderWithoutInitialCondition(criterion);
    }

    @Override
    public Optional<RenderedCriterion> visit(ExistsCriterion criterion) {
        ExistsPredicate existsPredicate = criterion.existsPredicate();
        SelectStatementProvider selectStatement = SelectRenderer.withSelectModel(existsPredicate.selectModelBuilder().build()).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).build().render();
        String fragment = existsPredicate.operator() + " (" + selectStatement.getSelectStatement() + ")";
        FragmentAndParameters initialCondition = FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).build();
        return this.renderWithInitialCondition(initialCondition, criterion);
    }

    private <T> FragmentAndParameters renderCondition(ColumnAndConditionCriterion<T> criterion) {
        WhereConditionVisitor<T> visitor = WhereConditionVisitor.withColumn(criterion.column()).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).withTableAliasCalculator(this.tableAliasCalculator).withParameterName(this.parameterName).build();
        return (FragmentAndParameters)criterion.condition().accept(visitor);
    }

    private List<RenderedCriterion> renderSubCriteria(SqlCriterion criterion) {
        return criterion.mapSubCriteria(c -> c.accept(this)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<RenderedCriterion> renderWithoutInitialCondition(SqlCriterion criterion) {
        List<RenderedCriterion> subCriteria = this.renderSubCriteria(criterion);
        if (subCriteria.isEmpty()) {
            return Optional.empty();
        }
        return this.calculateRenderedCriterion(subCriteria, criterion);
    }

    private Optional<RenderedCriterion> renderWithInitialCondition(FragmentAndParameters initialCondition, SqlCriterion criterion) {
        List<RenderedCriterion> subCriteria = this.renderSubCriteria(criterion);
        if (subCriteria.isEmpty()) {
            return this.calculateRenderedCriterion(initialCondition, criterion);
        }
        return this.calculateRenderedCriterion(initialCondition, criterion, subCriteria);
    }

    private Optional<RenderedCriterion> calculateRenderedCriterion(FragmentAndParameters initialCondition, SqlCriterion criterion) {
        return this.fromFragmentAndParameters(initialCondition, criterion);
    }

    private Optional<RenderedCriterion> calculateRenderedCriterion(List<RenderedCriterion> subCriteria, SqlCriterion criterion) {
        return this.calculateRenderedCriterion(subCriteria.get(0).fragmentAndParameters(), criterion, subCriteria.subList(1, subCriteria.size()));
    }

    private Optional<RenderedCriterion> calculateRenderedCriterion(FragmentAndParameters initialCondition, SqlCriterion criterion, List<RenderedCriterion> subCriteria) {
        FragmentCollector fc = subCriteria.stream().map(RenderedCriterion::fragmentAndParametersWithConnector).collect(FragmentCollector.collect(initialCondition));
        return this.fromFragmentAndParameters(FragmentAndParameters.withFragment(this.calculateFragment(fc)).withParameters(fc.parameters()).build(), criterion);
    }

    private String calculateFragment(FragmentCollector collector) {
        if (collector.hasMultipleFragments()) {
            return collector.fragments().collect(Collectors.joining(" ", "(", ")"));
        }
        return collector.fragments().findFirst().orElse("");
    }

    private Optional<RenderedCriterion> fromFragmentAndParameters(FragmentAndParameters fragmentAndParameters, SqlCriterion criterion) {
        RenderedCriterion.Builder builder = new RenderedCriterion.Builder().withFragmentAndParameters(fragmentAndParameters);
        criterion.connector().ifPresent(builder::withConnector);
        return Optional.of(builder.build());
    }

    public static class Builder {
        private AtomicInteger sequence;
        private RenderingStrategy renderingStrategy;
        private TableAliasCalculator tableAliasCalculator;
        private String parameterName;

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder withParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public CriterionRenderer build() {
            return new CriterionRenderer(this);
        }
    }
}

