/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ExistsPredicate;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.where.AbstractWhereDSL;
import org.mybatis.dynamic.sql.where.WhereApplier;

public abstract class AbstractWhereSupport<W extends AbstractWhereDSL<?>> {
    public abstract W where();

    public <T> W where(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion ... subCriteria) {
        return this.where(column, condition, Arrays.asList(subCriteria));
    }

    public <T> W where(BindableColumn<T> column, VisitableCondition<T> condition, List<SqlCriterion> subCriteria) {
        return (W)this.apply(w -> w.where(column, condition, subCriteria));
    }

    public W where(ExistsPredicate existsPredicate) {
        return (W)this.apply(w -> w.where(existsPredicate));
    }

    public W where(ExistsPredicate existsPredicate, SqlCriterion ... subCriteria) {
        return (W)this.apply(w -> w.where(existsPredicate, subCriteria));
    }

    public W applyWhere(WhereApplier whereApplier) {
        return (W)this.apply(w -> w.applyWhere(whereApplier));
    }

    private W apply(Consumer<W> block) {
        W dsl = this.where();
        block.accept(dsl);
        return dsl;
    }
}

