/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.render.JoinRenderer;
import org.mybatis.dynamic.sql.select.render.TableExpressionRenderer;
import org.mybatis.dynamic.sql.util.CustomCollectors;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class QueryExpressionRenderer {
    private final QueryExpressionModel queryExpression;
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence;
    private final TableExpressionRenderer tableExpressionRenderer;

    private QueryExpressionRenderer(Builder builder) {
        this.queryExpression = Objects.requireNonNull(builder.queryExpression);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.sequence = Objects.requireNonNull(builder.sequence);
        this.tableExpressionRenderer = new TableExpressionRenderer.Builder().withTableAliasCalculator(this.queryExpression.tableAliasCalculator()).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).build();
    }

    public FragmentAndParameters render() {
        FragmentAndParameters answer = this.calculateQueryExpressionStart();
        answer = this.addJoinClause(answer);
        answer = this.addWhereClause(answer);
        answer = this.addGroupByClause(answer);
        return answer;
    }

    private FragmentAndParameters calculateQueryExpressionStart() {
        String start = StringUtilities.spaceAfter(this.queryExpression.connector()) + "select " + (this.queryExpression.isDistinct() ? "distinct " : "") + this.calculateColumnList() + " from ";
        FragmentAndParameters renderedTable = this.renderTableExpression(this.queryExpression.table());
        start = start + renderedTable.fragment();
        return FragmentAndParameters.withFragment(start).withParameters(renderedTable.parameters()).build();
    }

    private String calculateColumnList() {
        return this.queryExpression.mapColumns(this::applyTableAndColumnAlias).collect(Collectors.joining(", "));
    }

    private String applyTableAndColumnAlias(BasicColumn selectListItem) {
        return selectListItem.renderWithTableAndColumnAlias(this.queryExpression.tableAliasCalculator());
    }

    private FragmentAndParameters renderTableExpression(TableExpression table) {
        return table.accept(this.tableExpressionRenderer);
    }

    private FragmentAndParameters addJoinClause(FragmentAndParameters partial) {
        return this.queryExpression.joinModel().map(this::renderJoin).map(fp -> partial.add(StringUtilities.spaceBefore(fp.fragment()), fp.parameters())).orElse(partial);
    }

    private FragmentAndParameters renderJoin(JoinModel joinModel) {
        return JoinRenderer.withJoinModel(joinModel).withQueryExpression(this.queryExpression).withTableExpressionRenderer(this.tableExpressionRenderer).build().render();
    }

    private FragmentAndParameters addWhereClause(FragmentAndParameters partial) {
        return this.queryExpression.whereModel().flatMap(this::renderWhereClause).map(wc -> partial.add(StringUtilities.spaceBefore(wc.getWhereClause()), wc.getParameters())).orElse(partial);
    }

    private Optional<WhereClauseProvider> renderWhereClause(WhereModel whereModel) {
        return WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy).withTableAliasCalculator(this.queryExpression.tableAliasCalculator()).withSequence(this.sequence).build().render();
    }

    private FragmentAndParameters addGroupByClause(FragmentAndParameters partial) {
        return this.queryExpression.groupByModel().map(this::renderGroupBy).map(s -> partial.add(StringUtilities.spaceBefore(s))).orElse(partial);
    }

    private String renderGroupBy(GroupByModel groupByModel) {
        return groupByModel.mapColumns(this::applyTableAlias).collect(CustomCollectors.joining(", ", "group by ", ""));
    }

    private String applyTableAlias(BasicColumn column) {
        return column.renderWithTableAlias(this.queryExpression.tableAliasCalculator());
    }

    public static Builder withQueryExpression(QueryExpressionModel model) {
        return new Builder().withQueryExpression(model);
    }

    public static class Builder {
        private QueryExpressionModel queryExpression;
        private RenderingStrategy renderingStrategy;
        private AtomicInteger sequence;

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public QueryExpressionRenderer build() {
            return new QueryExpressionRenderer(this);
        }
    }
}

