/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.InsertModel;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.PropertyWhenPresentMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;

public class InsertDSL<T>
implements Buildable<InsertModel<T>> {
    private final T row;
    private final SqlTable table;
    private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();

    private InsertDSL(T row, SqlTable table) {
        this.row = row;
        this.table = table;
    }

    public <F> ColumnMappingFinisher<F> map(SqlColumn<F> column) {
        return new ColumnMappingFinisher<F>(column);
    }

    @Override
    @NotNull
    public InsertModel<T> build() {
        return InsertModel.withRow(this.row).withTable(this.table).withColumnMappings(this.columnMappings).build();
    }

    public static <T> IntoGatherer<T> insert(T row) {
        return new IntoGatherer(row);
    }

    public class ColumnMappingFinisher<F> {
        private final SqlColumn<F> column;

        public ColumnMappingFinisher(SqlColumn<F> column) {
            this.column = column;
        }

        public InsertDSL<T> toProperty(String property) {
            InsertDSL.this.columnMappings.add(PropertyMapping.of(this.column, property));
            return InsertDSL.this;
        }

        public InsertDSL<T> toPropertyWhenPresent(String property, Supplier<?> valueSupplier) {
            InsertDSL.this.columnMappings.add(PropertyWhenPresentMapping.of(this.column, property, valueSupplier));
            return InsertDSL.this;
        }

        public InsertDSL<T> toNull() {
            InsertDSL.this.columnMappings.add(NullMapping.of(this.column));
            return InsertDSL.this;
        }

        public InsertDSL<T> toConstant(String constant) {
            InsertDSL.this.columnMappings.add(ConstantMapping.of(this.column, constant));
            return InsertDSL.this;
        }

        public InsertDSL<T> toStringConstant(String constant) {
            InsertDSL.this.columnMappings.add(StringConstantMapping.of(this.column, constant));
            return InsertDSL.this;
        }
    }

    public static class IntoGatherer<T> {
        private final T row;

        private IntoGatherer(T row) {
            this.row = row;
        }

        public InsertDSL<T> into(SqlTable table) {
            return new InsertDSL(this.row, table);
        }
    }
}

